/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.zosfiles.uss.types.GetAclType;

public class UssGetAclInputData {
    private final GetAclType type;
    private final String user;
    private final boolean useCommas;
    private final boolean suppressHeader;
    private final boolean suppressBaseAcl;

    public UssGetAclInputData(Builder builder) {
        this.type = builder.type;
        this.user = builder.user;
        this.useCommas = builder.usecommas;
        this.suppressHeader = builder.suppressheader;
        this.suppressBaseAcl = builder.suppressbaseacl;
    }

    public Optional<GetAclType> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    public boolean getUseCommas() {
        return this.useCommas;
    }

    public boolean getSuppressHeader() {
        return this.suppressHeader;
    }

    public boolean getSuppressBaseAcl() {
        return this.suppressBaseAcl;
    }

    public String toString() {
        return "UssGetAclInputData{type=" + this.type + ", user=" + this.user + ", useCommas=" + this.useCommas + ", suppressHeader=" + this.suppressHeader + ", suppressBaseAcl=" + this.suppressBaseAcl + "}";
    }

    public static class Builder {
        private GetAclType type;
        private String user;
        private boolean usecommas = false;
        private boolean suppressheader = false;
        private boolean suppressbaseacl = false;

        public Builder type(GetAclType type) {
            this.type = type;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder usecommas(boolean usecommas) {
            this.usecommas = usecommas;
            return this;
        }

        public Builder suppressheader(boolean suppressheader) {
            this.suppressheader = suppressheader;
            return this;
        }

        public Builder suppressbaseacl(boolean suppressbaseacl) {
            this.suppressbaseacl = suppressbaseacl;
            return this;
        }

        public UssGetAclInputData build() {
            return new UssGetAclInputData(this);
        }
    }
}

