/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.parse.JsonParseFactory;
import zowe.client.sdk.parse.UnixZfsJsonParse;
import zowe.client.sdk.parse.type.ParseType;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.JsonParserUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.UssListInputData;
import zowe.client.sdk.zosfiles.uss.input.UssListZfsInputData;
import zowe.client.sdk.zosfiles.uss.model.UnixFile;
import zowe.client.sdk.zosfiles.uss.model.UnixZfs;

public class UssList {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssList(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssList(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public List<UnixFile> getFiles(UssListInputData listInputData) throws ZosmfRequestException {
        int maxLength;
        ValidateUtils.checkNullParameter(listInputData == null, "listInputData is null");
        StringBuilder url = new StringBuilder(this.connection.getZosmfUrl() + "/restfiles/fs");
        url.append("?path=").append(EncodeUtils.encodeURIComponent(FileUtils.validatePath(listInputData.getPath().orElseThrow(() -> new IllegalArgumentException("path not specified")))));
        listInputData.getGroup().ifPresent(group -> url.append("&group=").append(EncodeUtils.encodeURIComponent(group)));
        listInputData.getUser().ifPresent(user -> url.append("&user=").append(EncodeUtils.encodeURIComponent(user)));
        listInputData.getMtime().ifPresent(mtime -> url.append("&mtime=").append(EncodeUtils.encodeURIComponent(mtime)));
        listInputData.getSize().ifPresent(size -> url.append("&size=").append(size));
        listInputData.getName().ifPresent(name -> url.append("&name=").append(EncodeUtils.encodeURIComponent(name)));
        listInputData.getPerm().ifPresent(perm -> url.append("&perm=").append(EncodeUtils.encodeURIComponent(perm)));
        if (listInputData.getSize().isPresent() && listInputData.getType().isPresent()) {
            url.append("&type=f");
        } else {
            listInputData.getType().ifPresent(type -> url.append("&type=").append(type.getValue()));
        }
        listInputData.getDepth().ifPresent(depth -> url.append("&depth=").append(depth));
        if (listInputData.isFilesys()) {
            url.append("&filesys=all");
        }
        if (listInputData.isSymlinks()) {
            url.append("&symlinks=report");
        }
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        if ((maxLength = listInputData.getMaxLength().orElse(0)) > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        this.request.setUrl(url.toString());
        Response response = this.request.executeRequest();
        ArrayList<UnixFile> items = new ArrayList<UnixFile>();
        JSONObject jsonObject = JsonParserUtils.parse(String.valueOf(response.getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned"))));
        JSONArray jsonArray = (JSONArray)jsonObject.get("items");
        if (jsonArray != null) {
            for (Object jsonObj : jsonArray) {
                items.add((UnixFile)JsonParseFactory.buildParser(ParseType.UNIX_FILE).parseResponse(jsonObj));
            }
        }
        return items;
    }

    public List<UnixZfs> getZfsSystems(UssListZfsInputData listZfsInputData) throws ZosmfRequestException {
        int maxLength;
        ValidateUtils.checkNullParameter(listZfsInputData == null, "listZfsInputData is null");
        ValidateUtils.checkIllegalParameter(listZfsInputData.getPath().isEmpty() && listZfsInputData.getFsname().isEmpty(), "no path or fsname specified");
        StringBuilder url = new StringBuilder(this.connection.getZosmfUrl() + "/restfiles/mfs");
        listZfsInputData.getPath().ifPresent(path -> url.append("?path=").append(EncodeUtils.encodeURIComponent(FileUtils.validatePath(path))));
        listZfsInputData.getFsname().ifPresent(fsname -> url.append("?fsname=").append(EncodeUtils.encodeURIComponent(fsname)));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        if ((maxLength = listZfsInputData.getMaxLength().orElse(0)) > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        this.request.setUrl(url.toString());
        Response response = this.request.executeRequest();
        ArrayList<UnixZfs> items = new ArrayList<UnixZfs>();
        JSONObject jsonObject = JsonParserUtils.parse(String.valueOf(response.getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned"))));
        JSONArray jsonArray = (JSONArray)jsonObject.get("items");
        if (jsonArray != null) {
            for (Object obj : jsonArray) {
                JSONObject jsonObj = (JSONObject)obj;
                StringBuilder modeStr = new StringBuilder();
                try {
                    JSONArray modeLst = (JSONArray)jsonObj.get("mode");
                    int size = modeLst.size();
                    for (int i = 0; i < size; ++i) {
                        if (size - 1 == i) {
                            modeStr.append(modeLst.get(i).toString());
                            continue;
                        }
                        modeStr.append(modeLst.get(i).toString()).append(",");
                    }
                }
                catch (Exception modeLst) {
                    // empty catch block
                }
                UnixZfsJsonParse parse = (UnixZfsJsonParse)JsonParseFactory.buildParser(ParseType.UNIX_ZFS);
                items.add(parse.parseResponse(jsonObj, modeStr.toString()));
            }
        }
        return items;
    }
}

