/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.methods;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StartTsoInputData;
import zowe.client.sdk.zostso.methods.TsoReply;
import zowe.client.sdk.zostso.methods.TsoSend;
import zowe.client.sdk.zostso.methods.TsoStart;
import zowe.client.sdk.zostso.methods.TsoStop;
import zowe.client.sdk.zostso.response.TsoStartResponse;

public class TsoCmd {
    private final List<String> msgLst = new ArrayList<String>();
    private final List<String> promptLst = new ArrayList<String>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ZosConnection connection;
    private final String accountNumber;
    private TsoStart tsoStart;
    private TsoStop tsoStop;
    private TsoSend tsoSend;
    private TsoReply tsoReply;
    private StartTsoInputData inputData;

    public TsoCmd(ZosConnection connection, String accountNumber) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkIllegalParameter(accountNumber, "accountNumber");
        this.connection = connection;
        this.accountNumber = accountNumber;
    }

    TsoCmd(ZosConnection connection, String accountNumber, TsoStart tsoStart, TsoStop tsoStop, TsoSend tsoSend, TsoReply tsoReply) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
        this.accountNumber = accountNumber;
        this.tsoStart = tsoStart;
        this.tsoStop = tsoStop;
        this.tsoSend = tsoSend;
        this.tsoReply = tsoReply;
    }

    public List<String> issueCommand(String command) throws ZosmfRequestException {
        return this.issueCommand(command, null);
    }

    public List<String> issueCommand(String command, StartTsoInputData inputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(command, "command");
        this.msgLst.clear();
        this.promptLst.clear();
        TsoStartResponse tsoStartResponse = this.startTso(inputData);
        if (!tsoStartResponse.isSuccess()) {
            JsonNode tsoData = this.getJsonNode(tsoStartResponse.getResponse()).get("tsoData");
            this.processTsoData(tsoData);
            return this.msgLst;
        }
        String responseStr = this.sendTsoCommand(tsoStartResponse.getSessionId(), command);
        JsonNode tsoData = this.getJsonNode(responseStr).get("tsoData");
        this.processTsoData(tsoData);
        boolean tsoMessagesReceived = false;
        while (!tsoMessagesReceived) {
            responseStr = this.sendTsoForReply(tsoStartResponse.getSessionId());
            tsoData = this.getJsonNode(responseStr).get("tsoData");
            this.processTsoData(tsoData);
            if (this.promptLst.isEmpty()) continue;
            tsoMessagesReceived = true;
        }
        this.stopTso(tsoStartResponse.getSessionId());
        return this.msgLst;
    }

    private TsoStartResponse startTso(StartTsoInputData inputData) throws ZosmfRequestException {
        if (this.tsoStart == null) {
            this.tsoStart = new TsoStart(this.connection);
        }
        this.inputData = inputData;
        if (this.inputData == null) {
            this.inputData = new StartTsoInputData();
        }
        this.inputData.setAccount(this.accountNumber);
        return this.tsoStart.start(this.inputData);
    }

    private String sendTsoCommand(String sessionId, String command) throws ZosmfRequestException {
        if (this.tsoSend == null) {
            this.tsoSend = new TsoSend(this.connection);
        }
        return this.tsoSend.sendCommand(sessionId, command);
    }

    private String sendTsoForReply(String sessionId) throws ZosmfRequestException {
        if (this.tsoReply == null) {
            this.tsoReply = new TsoReply(this.connection);
        }
        return this.tsoReply.reply(sessionId);
    }

    private void stopTso(String sessionId) throws ZosmfRequestException {
        if (this.tsoStop == null) {
            this.tsoStop = new TsoStop(this.connection);
        }
        this.tsoStop.stop(sessionId);
    }

    private void processTsoData(JsonNode tsoData) {
        if (tsoData == null || !tsoData.isArray()) {
            return;
        }
        tsoData.forEach(tsoDataItem -> {
            JsonNode promptNode;
            JsonNode messageNode = tsoDataItem.get("TSO MESSAGE");
            if (messageNode != null && messageNode.hasNonNull("DATA")) {
                this.msgLst.add(messageNode.get("DATA").asText());
            }
            if ((promptNode = tsoDataItem.get("TSO PROMPT")) != null && promptNode.hasNonNull("HIDDEN")) {
                this.promptLst.add(promptNode.get("HIDDEN").asText());
            }
        });
    }

    private JsonNode getJsonNode(String responseStr) throws ZosmfRequestException {
        JsonNode rootNode;
        try {
            rootNode = this.objectMapper.readTree(responseStr);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException("Response: " + e.getMessage());
        }
        return rootNode;
    }

    StartTsoInputData getInputData() {
        return this.inputData;
    }
}

