/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.atomic.AtomicInteger;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.exception.ZosmfRequestException;

public final class TsoUtils {
    private TsoUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getResponseStr(ZosmfRequest request) throws ZosmfRequestException {
        Response response = request.executeRequest();
        String responseStr = response.getResponsePhrase().orElseThrow(() -> new ZosmfRequestException("response phrase is either null or empty")).toString();
        AtomicInteger statusCode = new AtomicInteger();
        response.getStatusCode().ifPresent(statusCode::set);
        if (statusCode.get() < 100 || statusCode.get() > 299) {
            throw new ZosmfRequestException("Response: " + responseStr);
        }
        return responseStr;
    }

    public static String getMsgDataText(String responseStr) {
        String errMsg = "";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode rootNode = objectMapper.readTree(responseStr);
            rootNode = rootNode.get("msgData");
            if (rootNode.isArray() && rootNode.size() == 1) {
                errMsg = rootNode.get(0).get("messageText").asText();
            } else if (rootNode.isArray() && rootNode.size() > 1) {
                errMsg = rootNode.toPrettyString();
            } else if (rootNode.isObject()) {
                errMsg = rootNode.toPrettyString();
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return errMsg;
    }
}

