/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.methods;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.TsoUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.response.TsoCommonResponse;

public class TsoPing {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public TsoPing(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    TsoPing(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public TsoCommonResponse ping(String sessionId) throws ZosmfRequestException {
        TsoCommonResponse tsoCommonResponse;
        ValidateUtils.checkIllegalParameter(sessionId, "sessionId");
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso/ping/" + sessionId;
        if (this.request == null || !(this.request instanceof PutJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        String responseStr = TsoUtils.getResponseStr(this.request);
        try {
            tsoCommonResponse = this.objectMapper.readValue(responseStr, TsoCommonResponse.class);
        }
        catch (JsonProcessingException e) {
            String errMsg = TsoUtils.getMsgDataText(responseStr);
            throw new ZosmfRequestException(errMsg.isBlank() ? e.getMessage() : errMsg);
        }
        return tsoCommonResponse;
    }
}

