/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.core;

import kong.unirest.core.Cookie;
import zowe.client.sdk.core.AuthType;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.utility.ValidateUtils;

public class ZosConnectionFactory {
    private ZosConnectionFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static ZosConnection createBasicConnection(String host, String port, String user, String password) {
        return ZosConnectionFactory.createBasicZosConnection(host, port, user, password, null);
    }

    public static ZosConnection createBasicConnection(String host, String port, String user, String password, String basePath) {
        ValidateUtils.checkIllegalParameter(basePath, "basePath");
        return ZosConnectionFactory.createBasicZosConnection(host, port, user, password, basePath);
    }

    private static ZosConnection createBasicZosConnection(String host, String port, String user, String password, String basePath) {
        ValidateUtils.checkIllegalParameter(host, "host");
        ValidateUtils.checkIllegalParameter(port, "port");
        ValidateUtils.checkIllegalParameter(user, "user");
        ValidateUtils.checkIllegalParameter(password, "password");
        ZosConnection zosConnection = new ZosConnection(host, port, AuthType.BASIC);
        zosConnection.setUser(user);
        zosConnection.setPassword(password);
        zosConnection.setBasePath(basePath);
        return zosConnection;
    }

    public static ZosConnection createTokenConnection(String host, String port, Cookie token) {
        return ZosConnectionFactory.createTokenZosConnection(host, port, token, null);
    }

    public static ZosConnection createTokenConnection(String host, String port, Cookie token, String basePath) {
        ValidateUtils.checkIllegalParameter(basePath, "basePath");
        return ZosConnectionFactory.createTokenZosConnection(host, port, token, basePath);
    }

    private static ZosConnection createTokenZosConnection(String host, String port, Cookie token, String basePath) {
        ValidateUtils.checkIllegalParameter(host, "host");
        ValidateUtils.checkIllegalParameter(port, "port");
        ValidateUtils.checkNullParameter(token == null, "token is null");
        ZosConnection zosConnection = new ZosConnection(host, port, AuthType.TOKEN);
        zosConnection.setToken(token);
        zosConnection.setBasePath(basePath);
        return zosConnection;
    }

    public static ZosConnection createSslConnection(String host, String port, String certFilePath, String certPassword) {
        return ZosConnectionFactory.createSslZosConnection(host, port, certFilePath, certPassword, null);
    }

    public static ZosConnection createSslConnection(String host, String port, String certFilePath, String certPassword, String basePath) {
        ValidateUtils.checkIllegalParameter(basePath, "basePath");
        return ZosConnectionFactory.createSslZosConnection(host, port, certFilePath, certPassword, basePath);
    }

    private static ZosConnection createSslZosConnection(String host, String port, String certFilePath, String certPassword, String basePath) {
        ValidateUtils.checkIllegalParameter(host, "host");
        ValidateUtils.checkIllegalParameter(port, "port");
        ValidateUtils.checkIllegalParameter(certFilePath, "certificate file path (.p12)");
        ValidateUtils.checkIllegalParameter(certPassword, "certPassword");
        ZosConnection zosConnection = new ZosConnection(host, port, AuthType.SSL);
        zosConnection.setCertFilePath(certFilePath);
        zosConnection.setCertPassword(certPassword);
        zosConnection.setBasePath(basePath);
        return zosConnection;
    }
}

