/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.teamconfig.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.teamconfig.exception.TeamConfigException;
import zowe.client.sdk.utility.JsonUtils;

public class Profile {
    private final String name;
    private final String type;
    private final JSONArray secure;
    private final Map<String, String> properties;

    public Profile(String name, String type, JSONObject obj, JSONArray secure) throws TeamConfigException {
        this.name = name;
        this.type = type;
        try {
            this.properties = JsonUtils.parseMap(obj);
        }
        catch (JsonProcessingException e) {
            throw new TeamConfigException("Error parsing properties", e);
        }
        this.secure = secure;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public JSONArray getSecure() {
        return this.secure;
    }

    public String toString() {
        return "Profile{name='" + this.name + "', type='" + this.type + "', secure=" + this.secure + ", properties=" + this.properties + "}";
    }
}

