/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.utility;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;

public final class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String PARSE_ERROR_MSG = "json response parse error";

    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static JSONObject parse(String item) throws ZosmfRequestException {
        try {
            return (JSONObject)new JSONParser().parse(item);
        }
        catch (ParseException e) {
            LOG.debug(PARSE_ERROR_MSG, e);
            throw new ZosmfRequestException(e.getMessage(), e);
        }
    }

    public static JSONArray parseArray(String item) throws ZosmfRequestException {
        try {
            return (JSONArray)new JSONParser().parse(item);
        }
        catch (ParseException e) {
            LOG.debug(PARSE_ERROR_MSG, e);
            throw new ZosmfRequestException(e.getMessage(), e);
        }
    }

    public static <T> T parseResponse(String json, Class<T> clazz, String context) throws ZosmfRequestException {
        try {
            return objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException("Failed to parse JSON response for [" + context + "] into " + clazz.getSimpleName(), e);
        }
    }

    public static Map<String, String> parseMap(JSONObject jsonObject) throws JsonProcessingException {
        JsonNode root = objectMapper.readTree(jsonObject.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<Map.Entry<String, JsonNode>> fields = root.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> entry = fields.next();
            map.put(entry.getKey(), entry.getValue().asText());
        }
        return map;
    }
}

