/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.utility.ValidateUtils;

public class UssListZfsInputData {
    private final Integer maxLength;
    private final String path;
    private final String fsname;

    public UssListZfsInputData(Builder builder) {
        this.maxLength = builder.maxLength;
        this.path = builder.path;
        this.fsname = builder.fsname;
    }

    public OptionalInt getMaxLength() {
        return this.maxLength == null ? OptionalInt.empty() : OptionalInt.of(this.maxLength);
    }

    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public Optional<String> getFsname() {
        return Optional.ofNullable(this.fsname);
    }

    public String toString() {
        return "UssListZfsInputData{maxLength=" + this.maxLength + ", path=" + this.path + ", fsname=" + this.fsname + "}";
    }

    public static class Builder {
        private Integer maxLength;
        private String path;
        private String fsname;

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder path(String path) {
            ValidateUtils.checkNullParameter(path == null, "path is null");
            ValidateUtils.checkIllegalParameter(path.isBlank(), "path not specified");
            if (this.fsname != null) {
                throw new IllegalStateException("cannot specify both path and fsname parameters");
            }
            this.path = path;
            return this;
        }

        public Builder fsname(String fsname) {
            ValidateUtils.checkNullParameter(fsname == null, "fsname is null");
            ValidateUtils.checkIllegalParameter(fsname.isBlank(), "fsname not specified");
            if (this.path != null) {
                throw new IllegalStateException("cannot specify both path and fsname parameters");
            }
            this.fsname = fsname;
            return this;
        }

        public UssListZfsInputData build() {
            return new UssListZfsInputData(this);
        }
    }
}

