/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.List;
import java.util.Map;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.JsonUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.UssListInputData;
import zowe.client.sdk.zosfiles.uss.input.UssListZfsInputData;
import zowe.client.sdk.zosfiles.uss.model.UnixFile;
import zowe.client.sdk.zosfiles.uss.model.UnixZfs;
import zowe.client.sdk.zosfiles.uss.reaponse.UnixFileListResponse;
import zowe.client.sdk.zosfiles.uss.reaponse.UnixZfsListResponse;

public class UssList {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssList(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssList(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public List<UnixFile> getFiles(UssListInputData listInputData) throws ZosmfRequestException {
        int maxLength;
        ValidateUtils.checkNullParameter(listInputData == null, "listInputData is null");
        String urlStart = this.connection.getZosmfUrl() + "/restfiles/fs";
        StringBuilder url = new StringBuilder(urlStart);
        url.append("?path=").append(EncodeUtils.encodeURIComponent(FileUtils.validatePath(listInputData.getPath().orElseThrow(() -> new IllegalArgumentException("path not specified")))));
        listInputData.getGroup().ifPresent(group -> url.append("&group=").append(EncodeUtils.encodeURIComponent(group)));
        listInputData.getUser().ifPresent(user -> url.append("&user=").append(EncodeUtils.encodeURIComponent(user)));
        listInputData.getMtime().ifPresent(mtime -> url.append("&mtime=").append(EncodeUtils.encodeURIComponent(mtime)));
        listInputData.getSize().ifPresent(size -> url.append("&size=").append(size));
        listInputData.getName().ifPresent(name -> url.append("&name=").append(EncodeUtils.encodeURIComponent(name)));
        listInputData.getPerm().ifPresent(perm -> url.append("&perm=").append(EncodeUtils.encodeURIComponent(perm)));
        if (listInputData.getSize().isPresent() && listInputData.getType().isPresent()) {
            url.append("&type=f");
        } else {
            listInputData.getType().ifPresent(type -> url.append("&type=").append(type.getValue()));
        }
        listInputData.getDepth().ifPresent(depth -> url.append("&depth=").append(depth));
        if (listInputData.isFilesys()) {
            url.append("&filesys=all");
        }
        if (listInputData.isSymlinks()) {
            url.append("&symlinks=report");
        }
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        if ((maxLength = listInputData.getMaxLength().orElse(0)) > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        this.request.setUrl(url.toString());
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned")).toString();
        String context = "getFiles";
        UnixFileListResponse response = JsonUtils.parseResponse(responsePhrase, UnixFileListResponse.class, "getFiles");
        return response.getItems() == null ? List.of() : response.getItems();
    }

    public List<UnixZfs> getZfsSystems(UssListZfsInputData listZfsInputData) throws ZosmfRequestException {
        int maxLength;
        ValidateUtils.checkNullParameter(listZfsInputData == null, "listZfsInputData is null");
        ValidateUtils.checkIllegalParameter(listZfsInputData.getPath().isEmpty() && listZfsInputData.getFsname().isEmpty(), "no path or fsname specified");
        String urlStart = this.connection.getZosmfUrl() + "/restfiles/mfs";
        StringBuilder url = new StringBuilder(urlStart);
        listZfsInputData.getPath().ifPresent(path -> url.append("?path=").append(EncodeUtils.encodeURIComponent(FileUtils.validatePath(path))));
        listZfsInputData.getFsname().ifPresent(fsname -> url.append("?fsname=").append(EncodeUtils.encodeURIComponent(fsname)));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        if ((maxLength = listZfsInputData.getMaxLength().orElse(0)) > 0) {
            this.request.setHeaders(Map.of("X-IBM-Max-Items", String.valueOf(maxLength)));
        }
        this.request.setUrl(url.toString());
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned")).toString();
        String context = "getZfsSystems";
        UnixZfsListResponse response = JsonUtils.parseResponse(responsePhrase, UnixZfsListResponse.class, "getZfsSystems");
        return response.getItems() == null ? List.of() : response.getItems();
    }
}

