/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.methods;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.GetTextZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.JsonUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosjobs.input.CommonJobInputData;
import zowe.client.sdk.zosjobs.input.JobGetInputData;
import zowe.client.sdk.zosjobs.model.Job;
import zowe.client.sdk.zosjobs.model.JobFile;

public class JobGet {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private String url;

    public JobGet(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    JobGet(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        this.request = request;
        if (!(request instanceof GetJsonZosmfRequest) && !(request instanceof GetTextZosmfRequest)) {
            throw new IllegalStateException("GET_JSON or GET_TEXT request type required");
        }
    }

    public String getJcl(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.getJclCommon(new CommonJobInputData(jobId, jobName));
    }

    public String getJclByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getJclCommon(new CommonJobInputData(job.getJobId(), job.getJobName()));
    }

    public String getJclCommon(CommonJobInputData commonInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(commonInputData == null, "commonInputData is null");
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(commonInputData.getJobName().get()) + "/" + commonInputData.getJobId().get() + "/files/JCL/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        return (String)this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job jcl response phrase"));
    }

    public Job getById(String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        List<Job> jobs = this.getCommon(new JobGetInputData.Builder("*").jobId(jobId).build());
        if (jobs.isEmpty()) {
            throw new IllegalStateException("job not found");
        }
        if (jobs.size() > 1) {
            throw new IllegalStateException("expected 1 job returned but received " + jobs.size() + " jobs.");
        }
        return jobs.get(0);
    }

    public List<Job> getAll() throws ZosmfRequestException {
        return this.getCommon(null);
    }

    public List<Job> getByOwner(String owner) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(owner, "owner");
        return this.getCommon(new JobGetInputData.Builder(owner).build());
    }

    public List<Job> getByOwnerAndPrefix(String owner, String prefix) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(owner, "owner");
        ValidateUtils.checkIllegalParameter(prefix, "prefix");
        return this.getCommon(new JobGetInputData.Builder(owner).prefix(prefix).build());
    }

    public List<Job> getByPrefix(String prefix) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(prefix, "prefix");
        return this.getCommon(new JobGetInputData.Builder("*").prefix(prefix).build());
    }

    public List<Job> getCommon(JobGetInputData getInputData) throws ZosmfRequestException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs?";
        if (getInputData != null) {
            if (getInputData.getOwner().isPresent()) {
                this.url = this.url + "owner=" + getInputData.getOwner().get();
            }
            if (getInputData.getPrefix().isPresent() && !"*".equals(getInputData.getPrefix().get())) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "prefix=" + EncodeUtils.encodeURIComponent(getInputData.getPrefix().get());
            }
            if (getInputData.getMaxJobs().isPresent() && getInputData.getMaxJobs().getAsInt() != 1000) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "max-jobs=" + getInputData.getMaxJobs().getAsInt();
            }
            if (getInputData.getJobId().isPresent()) {
                if (this.url.contains("?")) {
                    this.url = this.url + "&";
                }
                this.url = this.url + "jobid=" + getInputData.getJobId().get();
            }
        } else if (this.connection.getUser() != null && !this.connection.getUser().isEmpty()) {
            this.url = this.url + "owner=" + this.connection.getUser();
        }
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no get job response phrase")).toString();
        String context = "getCommon";
        JSONArray results = JsonUtils.parseArray(responsePhrase);
        for (Object jsonObj : results) {
            jobs.add(JsonUtils.parseResponse(String.valueOf(jsonObj), Job.class, "getCommon"));
        }
        return jobs;
    }

    public String getSpoolContent(JobFile jobFile) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        return this.getSpoolContentCommon(jobFile);
    }

    public String getSpoolContent(String jobName, String jobId, Long spoolId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        ValidateUtils.checkIllegalParameter(spoolId <= 0L, "spool id not specified");
        return this.getSpoolContentCommon(new JobFile(jobName, jobId, spoolId));
    }

    public String getSpoolContentCommon(JobFile jobFile) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(jobFile == null, "jobFile is null");
        if (jobFile.getJobName().isEmpty() || jobFile.getJobId().isEmpty() || jobFile.getId() == 0L) {
            throw new ZosmfRequestException("jobFileName, JobId or jobFileId is either null or empty");
        }
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(jobFile.getJobName()) + "/" + jobFile.getJobId() + "/files/" + jobFile.getId() + "/records";
        if (this.request == null || !(this.request instanceof GetTextZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_TEXT);
        }
        this.request.setUrl(this.url);
        String spoolErrMsg = "no job spool file content response phrase";
        return this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job spool file content response phrase")).toString();
    }

    public List<JobFile> getSpoolFiles(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.getSpoolFilesCommon(new CommonJobInputData(jobId, jobName));
    }

    public List<JobFile> getSpoolFilesCommon(CommonJobInputData commonInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(commonInputData == null, "commonInputData is null");
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(commonInputData.getJobName().get()) + "/" + commonInputData.getJobId().get() + "/files";
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        ArrayList<JobFile> files = new ArrayList<JobFile>();
        String spoolErrMsg = "no job spool files phrase";
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no job spool files phrase")).toString();
        String context = "getSpoolFilesCommon";
        JSONArray results = JsonUtils.parseArray(responsePhrase);
        for (Object obj : results) {
            JSONObject jsonObj = (JSONObject)obj;
            files.add(JsonUtils.parseResponse(jsonObj.toJSONString(), JobFile.class, "getSpoolFilesCommon"));
        }
        return files;
    }

    public List<JobFile> getSpoolFilesByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getSpoolFilesCommon(new CommonJobInputData(job.getJobId(), job.getJobName()));
    }

    public Job getStatus(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        return this.getStatusCommon(new CommonJobInputData(jobId, jobName, true));
    }

    public Job getStatusCommon(CommonJobInputData commonInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(commonInputData == null, "commonInputData is null");
        if (commonInputData.getJobName().isEmpty()) {
            throw new IllegalStateException("jobName is either null or empty");
        }
        if (commonInputData.getJobId().isEmpty()) {
            throw new IllegalStateException("jobId is either null or empty");
        }
        this.url = this.connection.getZosmfUrl() + "/restjobs/jobs/" + EncodeUtils.encodeURIComponent(commonInputData.getJobName().get()) + "/" + commonInputData.getJobId().get();
        if (commonInputData.isStepData()) {
            this.url = this.url + "?step-data=Y";
        }
        if (this.request == null || !(this.request instanceof GetJsonZosmfRequest)) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(this.url);
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no get job response phrase")).toString();
        String context = "getStatusCommon";
        return JsonUtils.parseResponse(responsePhrase, Job.class, "getStatusCommon");
    }

    public Job getStatusByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        return this.getStatusCommon(new CommonJobInputData(job.getJobId(), job.getJobName(), true));
    }

    public String getStatusValue(String jobName, String jobId) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(jobName, "jobName");
        ValidateUtils.checkIllegalParameter(jobId, "jobId");
        Job job = this.getStatusCommon(new CommonJobInputData(jobId, jobName));
        return job.getStatus();
    }

    public String getStatusValueByJob(Job job) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(job == null, "job is null");
        Job result = this.getStatusCommon(new CommonJobInputData(job.getJobId(), job.getJobName()));
        return result.getStatus();
    }

    public String getUrl() {
        return this.url;
    }
}

