/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import zowe.client.sdk.zosjobs.model.JobStepData;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Job {
    private final String jobId;
    private final String jobName;
    private final String subSystem;
    private final String owner;
    private final String status;
    private final String type;
    private final String classs;
    private final String retCode;
    private final JobStepData[] stepData;
    private final String url;
    private final String filesUrl;
    private final String jobCorrelator;
    private final Long phase;
    private final String phaseName;

    @JsonCreator
    public Job(@JsonProperty(value="jobid") String jobId, @JsonProperty(value="jobname") String jobName, @JsonProperty(value="subsystem") String subSystem, @JsonProperty(value="owner") String owner, @JsonProperty(value="status") String status, @JsonProperty(value="type") String type, @JsonProperty(value="class") String classs, @JsonProperty(value="retcode") String retCode, @JsonProperty(value="step-data") JobStepData[] stepData, @JsonProperty(value="url") String url, @JsonProperty(value="files-url") String filesUrl, @JsonProperty(value="job-correlator") String jobCorrelator, @JsonProperty(value="phase") Long phase, @JsonProperty(value="phase-name") String phaseName) {
        this.jobId = jobId == null ? "" : jobId;
        this.jobName = jobName == null ? "" : jobName;
        this.subSystem = subSystem == null ? "" : subSystem;
        this.owner = owner == null ? "" : owner;
        this.status = status == null ? "" : status;
        this.type = type == null ? "" : type;
        this.classs = classs == null ? "" : classs;
        this.retCode = retCode == null ? "" : retCode;
        this.stepData = stepData == null ? new JobStepData[]{} : stepData;
        this.url = url;
        this.filesUrl = filesUrl == null ? "" : filesUrl;
        this.jobCorrelator = jobCorrelator == null ? "" : jobCorrelator;
        this.phase = phase == null ? 0L : phase;
        this.phaseName = phaseName == null ? "" : phaseName;
    }

    private Job(Builder builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.subSystem = builder.subSystem;
        this.owner = builder.owner;
        this.status = builder.status;
        this.type = builder.type;
        this.classs = builder.classs;
        this.retCode = builder.retCode;
        this.stepData = builder.stepData;
        this.url = builder.url;
        this.filesUrl = builder.filesUrl;
        this.jobCorrelator = builder.jobCorrelator;
        this.phase = builder.phase;
        this.phaseName = builder.phaseName;
    }

    public String getClasss() {
        return this.classs;
    }

    public String getFilesUrl() {
        return this.filesUrl;
    }

    public String getJobCorrelator() {
        return this.jobCorrelator;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getOwner() {
        return this.owner;
    }

    public Long getPhase() {
        return this.phase;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getRetCode() {
        return this.retCode;
    }

    public String getStatus() {
        return this.status;
    }

    public JobStepData[] getStepData() {
        return this.stepData;
    }

    public String getSubSystem() {
        return this.subSystem;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "Job{jobId='" + this.jobId + "', jobName='" + this.jobName + "', subSystem='" + this.subSystem + "', owner='" + this.owner + "', status='" + this.status + "', type='" + this.type + "', classs='" + this.classs + "', retCode='" + this.retCode + "', stepData=" + (Serializable)(this.stepData != null ? Integer.valueOf(this.stepData.length) : "null") + ", url='" + this.url + "', filesUrl='" + this.filesUrl + "', jobCorrelator='" + this.jobCorrelator + "', phase=" + this.phase + ", phaseName='" + this.phaseName + "'}";
    }

    public static class Builder {
        private String jobId;
        private String jobName;
        private String subSystem;
        private String owner;
        private String status;
        private String type;
        private String classs;
        private String retCode;
        private JobStepData[] stepData;
        private String url;
        private String filesUrl;
        private String jobCorrelator;
        private Long phase;
        private String phaseName;

        public Builder classs(String classs) {
            this.classs = classs;
            return this;
        }

        public Builder filesUrl(String filesUrl) {
            this.filesUrl = filesUrl;
            return this;
        }

        public Builder jobCorrelator(String jobCorrelator) {
            this.jobCorrelator = jobCorrelator;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder phase(Long phase) {
            this.phase = phase;
            return this;
        }

        public Builder phaseName(String phaseName) {
            this.phaseName = phaseName;
            return this;
        }

        public Builder retCode(String retCode) {
            this.retCode = retCode;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder stepData(JobStepData[] stepData) {
            this.stepData = stepData;
            return this;
        }

        public Builder subSystem(String subSystem) {
            this.subSystem = subSystem;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Job build() {
            return new Job(this);
        }
    }
}

