/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zostso.methods;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PostJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.TsoUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zostso.input.StartTsoInputData;
import zowe.client.sdk.zostso.response.TsoStartResponse;

public class TsoStart {
    private final ZosConnection connection;
    private ZosmfRequest request;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public TsoStart(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    TsoStart(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PostJsonZosmfRequest)) {
            throw new IllegalStateException("POST_JSON request type required");
        }
        this.request = request;
    }

    public TsoStartResponse start(StartTsoInputData inputData) throws ZosmfRequestException {
        JsonNode rootNode;
        ValidateUtils.checkNullParameter(inputData == null, "inputData is null");
        String url = this.connection.getZosmfUrl() + "/tsoApp/tso?acct=" + EncodeUtils.encodeURIComponent(inputData.getAccount().orElseThrow(() -> new ZosmfRequestException("accountNumber is not specified"))) + "&proc=" + inputData.getLogonProcedure().orElse("IZUFPROC") + "&chset=" + inputData.getCharacterSet().orElse("697") + "&cpage=" + inputData.getCodePage().orElse("1047") + "&rows=" + inputData.getRows().orElse("24") + "&cols=" + inputData.getColumns().orElse("80") + "&rsize=" + inputData.getRegionSize().orElse("4096");
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.POST_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody("");
        String responseStr = TsoUtils.getResponseStr(this.request);
        try {
            rootNode = this.objectMapper.readTree(responseStr);
        }
        catch (JsonProcessingException e) {
            throw new ZosmfRequestException(e.getMessage());
        }
        JsonNode keyNode = rootNode.get("servletKey");
        if (keyNode == null || keyNode.isNull()) {
            String errMsg = "Response missing servletKey: " + responseStr;
            throw new ZosmfRequestException(errMsg);
        }
        String servletKey = keyNode.asText();
        if (servletKey == null || servletKey.trim().isEmpty() || "null".equalsIgnoreCase(servletKey)) {
            String errMsg = "Response servletKey is empty: " + responseStr;
            throw new ZosmfRequestException(errMsg);
        }
        if (responseStr.contains("IKJ56455I")) {
            return new TsoStartResponse(true, servletKey, responseStr);
        }
        return new TsoStartResponse(false, servletKey, responseStr);
    }
}

