/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.JsonUtils;
import zowe.client.sdk.utility.ValidateUtils;

public class UssExtAttr {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssExtAttr(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssExtAttr(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public String display(String targetPath) throws ZosmfRequestException {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("request", "extattr");
        Response response = this.executeRequest(targetPath, requestMap);
        JSONObject json = JsonUtils.parse(response.getResponsePhrase().orElseThrow(() -> new IllegalStateException("response phrase not returned")).toString());
        StringBuilder str = new StringBuilder();
        ((JSONArray)json.get((Object)"stdout")).forEach(item -> str.append(item.toString()).append("\n"));
        return str.toString();
    }

    public Response set(String targetPath, String value) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(this.isNotValidAttributes(value), "specified valid value character sequence");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("request", "extattr");
        requestMap.put("set", value);
        return this.executeRequest(targetPath, requestMap);
    }

    public Response reset(String targetPath, String value) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(this.isNotValidAttributes(value), "specified valid value character sequence");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("request", "extattr");
        requestMap.put("reset", value);
        return this.executeRequest(targetPath, requestMap);
    }

    private Response executeRequest(String targetPath, Map<String, String> jsonMap) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(targetPath, "targetPath");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(targetPath));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(jsonMap).toString());
        return this.request.executeRequest();
    }

    private boolean isNotValidAttributes(String value) {
        return !Pattern.compile("^(?!.*(.).*\\1)[apls]+$").matcher(value).matches();
    }
}

