/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zoslogs.method;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.JsonUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zoslogs.input.ZosLogInputData;
import zowe.client.sdk.zoslogs.response.ZosLogResponse;

public class ZosLog {
    private static final String RESOURCE = "/restconsoles/v1/log";
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosLog(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    ZosLog(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosLogResponse issueCommand(ZosLogInputData logInputData) throws ZosmfRequestException {
        ValidateUtils.checkNullParameter(logInputData == null, "logInputData is null");
        String defaultUrl = this.connection.getZosmfUrl() + RESOURCE;
        StringBuilder url = new StringBuilder(defaultUrl);
        String customPattern = "yyyy-MM-dd'T'HH:mm'Z'";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm'Z'");
        logInputData.getStartTime().ifPresentOrElse(time -> url.append("?time=").append((String)time), () -> url.append("?time=").append(LocalDateTime.now().format(formatter)));
        logInputData.getTimeRange().ifPresent(timeRange -> {
            if (logInputData.getQueryCount() > 1) {
                url.append("&timeRange=").append((String)timeRange);
            } else {
                url.append("?timeRange=").append((String)timeRange);
            }
        });
        logInputData.getDirection().ifPresent(direction -> {
            if (logInputData.getQueryCount() > 1) {
                url.append("&direction=").append(direction.getValue());
            } else {
                url.append("?direction=").append(direction.getValue());
            }
        });
        logInputData.getHardCopy().ifPresent(hardCopy -> {
            if (logInputData.getQueryCount() > 1) {
                url.append("&hardcopy=").append(hardCopy.getValue());
            } else {
                url.append("?hardcopy=").append(hardCopy.getValue());
            }
        });
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url.toString().replace("?&", "?"));
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no zos log response phrase")).toString();
        String context = "issueCommand";
        return JsonUtils.parseResponse(responsePhrase, ZosLogResponse.class, "issueCommand");
    }
}

