/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.teamconfig;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.teamconfig.exception.TeamConfigException;
import zowe.client.sdk.teamconfig.keytar.KeyTarConfig;
import zowe.client.sdk.teamconfig.keytar.KeyTarImpl;
import zowe.client.sdk.teamconfig.model.ConfigContainer;
import zowe.client.sdk.teamconfig.model.Partition;
import zowe.client.sdk.teamconfig.model.Profile;
import zowe.client.sdk.teamconfig.model.ProfileDao;
import zowe.client.sdk.teamconfig.service.KeyTarService;
import zowe.client.sdk.teamconfig.service.TeamConfigService;
import zowe.client.sdk.utility.ValidateUtils;

public class TeamConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TeamConfig.class);
    private final TeamConfigService teamConfigService;
    private final KeyTarService keyTarService;
    private final String BASE_PROFILE_NAME = "base";
    private final Predicate<Profile> isBaseProfile = i -> i.getName().equals("base");
    private KeyTarConfig keyTarConfig;
    private ConfigContainer teamConfig;

    public TeamConfig() throws TeamConfigException {
        this.keyTarService = new KeyTarService(new KeyTarImpl());
        this.teamConfigService = new TeamConfigService();
        this.config();
    }

    public TeamConfig(KeyTarService keyTarService, TeamConfigService teamConfigService) throws TeamConfigException {
        this.keyTarService = keyTarService;
        this.teamConfigService = teamConfigService;
        this.config();
    }

    private void config() throws TeamConfigException {
        this.keyTarConfig = this.keyTarService.getKeyTarConfig();
        this.teamConfig = this.teamConfigService.getTeamConfig(this.keyTarConfig);
        LOG.debug("keyTarConfig {}", (Object)this.keyTarConfig);
        LOG.debug("teamConfig {}", (Object)this.teamConfig);
    }

    public ProfileDao getDefaultProfile(String profileType) throws TeamConfigException {
        ValidateUtils.checkIllegalParameter(profileType, "profileType");
        Optional<String> defaultName = Optional.ofNullable(this.teamConfig.getDefaults().get(profileType));
        Predicate<Profile> isProfileName = i -> i.getName().equals(defaultName.orElse(profileType));
        Optional<Profile> base = this.teamConfig.getProfiles().stream().filter(this.isBaseProfile).findFirst();
        Optional<Profile> target = this.teamConfig.getProfiles().stream().filter(isProfileName).findFirst();
        if (target.isEmpty() || !target.get().getType().equalsIgnoreCase(profileType)) {
            throw new IllegalStateException("Found no profile of type " + profileType + " in Zowe client configuration.");
        }
        target = Optional.of(this.merge(target.orElse(null), base.orElse(null)));
        return new ProfileDao(target.get(), this.keyTarConfig.getUserName(), this.keyTarConfig.getPassword(), target.get().getProperties().get("host"), target.get().getProperties().get("port"));
    }

    public ProfileDao getDefaultProfileFromPartition(String profileName, String partitionName) throws TeamConfigException {
        ValidateUtils.checkIllegalParameter(profileName, "profileName");
        ValidateUtils.checkIllegalParameter(partitionName, "partitionName");
        Optional<String> defaultName = Optional.ofNullable(this.teamConfig.getDefaults().get(profileName));
        Predicate<Profile> isProfileName = i -> i.getName().equals(defaultName.orElse(profileName));
        Predicate<Partition> isPartitionName = i -> i.getName().equals(partitionName);
        Optional<Profile> base = this.teamConfig.getProfiles().stream().filter(this.isBaseProfile).findFirst();
        Optional<Partition> partition = this.teamConfig.getPartitions().stream().filter(isPartitionName).findFirst();
        if (partition.isEmpty()) {
            throw new IllegalStateException("Found no " + partitionName + " in Zowe client configuration.");
        }
        Optional<Profile> target = partition.get().getProfiles().stream().filter(isProfileName).findFirst();
        if (target.isEmpty()) {
            throw new IllegalStateException("Found no " + profileName + " within Zowe client configuration partition");
        }
        target = Optional.of(this.merge(target.orElse(null), base.orElse(null)));
        return new ProfileDao(target.get(), this.keyTarConfig.getUserName(), this.keyTarConfig.getPassword(), target.get().getProperties().get("host"), target.get().getProperties().get("port"));
    }

    private Profile merge(Profile target, Profile base) throws TeamConfigException {
        Optional<Object> targetProps = Optional.empty();
        Optional<Object> baseProps = Optional.empty();
        if (target != null) {
            targetProps = Optional.ofNullable(target.getProperties());
        }
        if (base != null) {
            baseProps = Optional.ofNullable(base.getProperties());
        }
        if (targetProps.isPresent() && baseProps.isPresent()) {
            Map<String, String> mergedMap = Stream.concat(((Map)targetProps.get()).entrySet().stream().filter(Objects::nonNull), ((Map)baseProps.get()).entrySet().stream().filter(Objects::nonNull)).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue));
            return new Profile(target.getName(), target.getType(), new JSONObject(mergedMap), target.getSecure());
        }
        return target;
    }
}

