/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.core;

import java.util.Objects;
import java.util.Optional;
import kong.unirest.core.Cookie;
import zowe.client.sdk.core.AuthType;

public final class ZosConnection {
    private final String host;
    private final String zosmfPort;
    private final AuthType authType;
    private String user;
    private String password;
    private Cookie token;
    private String certFilePath;
    private String certPassword;
    private String basePath;

    ZosConnection(String host, String zosmfPort, AuthType authType) {
        this.host = host;
        this.zosmfPort = zosmfPort;
        this.authType = authType;
    }

    public String getHost() {
        return this.host;
    }

    public String getZosmfPort() {
        return this.zosmfPort;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public Cookie getToken() {
        return this.token;
    }

    void setToken(Cookie token) {
        this.token = token;
    }

    public String getCertFilePath() {
        return this.certFilePath;
    }

    void setCertFilePath(String certFilePath) {
        this.certFilePath = certFilePath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public Optional<String> getBasePath() {
        return Optional.ofNullable(this.basePath);
    }

    public String getZosmfUrl() {
        return "https://" + this.host + ":" + this.zosmfPort + (this.basePath != null ? this.basePath : "") + "/zosmf";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZosConnection that = (ZosConnection)obj;
        if (!(Objects.equals(this.host, that.host) && Objects.equals(this.zosmfPort, that.zosmfPort) && this.authType == that.authType && Objects.equals(this.basePath, that.basePath))) {
            return false;
        }
        switch (this.authType) {
            case BASIC: {
                return Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password);
            }
            case TOKEN: {
                String thisTokenValue = this.token != null ? this.token.getValue() : null;
                String thatTokenValue = that.token != null ? that.token.getValue() : null;
                return Objects.equals(thisTokenValue, thatTokenValue);
            }
            case SSL: {
                return Objects.equals(this.certFilePath, that.certFilePath) && Objects.equals(this.certPassword, that.certPassword);
            }
        }
        return false;
    }

    public int hashCode() {
        switch (this.authType) {
            case BASIC: {
                return Objects.hash(new Object[]{this.host, this.zosmfPort, this.authType, this.user, this.password, this.basePath});
            }
            case TOKEN: {
                String tokenValue = this.token != null ? this.token.getValue() : null;
                return Objects.hash(new Object[]{this.host, this.zosmfPort, this.authType, tokenValue, this.basePath});
            }
            case SSL: {
                return Objects.hash(new Object[]{this.host, this.zosmfPort, this.authType, this.certFilePath, this.certPassword, this.basePath});
            }
        }
        return Objects.hash(new Object[]{this.host, this.zosmfPort, this.authType, this.basePath});
    }

    public String toString() {
        return "ZosConnection{host='" + this.host + "', zosmfPort='" + this.zosmfPort + "', authType=" + this.authType + ", user='" + this.user + "', password='*****'', token=" + this.token + ", certFilePath='" + this.certFilePath + "', certPassword='" + this.certPassword + "', basePath='" + this.basePath + "'}";
    }
}

