/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.types.LinkType;

public class UssChangeModeInputData {
    private final String mode;
    private final boolean recursive;
    private final LinkType links;

    public UssChangeModeInputData(Builder builder) {
        this.mode = builder.mode;
        this.recursive = builder.recursive;
        this.links = builder.links;
    }

    public Optional<String> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public Optional<LinkType> getLinks() {
        return Optional.ofNullable(this.links);
    }

    public String toString() {
        return "UssChangeModeInputData{mode=" + this.mode + ", recursive=" + this.recursive + ", links=" + this.links + "}";
    }

    public static class Builder {
        private String mode;
        private boolean recursive = false;
        private LinkType links;

        public Builder mode(String mode) {
            ValidateUtils.checkNullParameter(mode == null, "mode is null");
            ValidateUtils.checkIllegalParameter(mode.isBlank(), "mode not specified");
            this.mode = mode;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder links(LinkType type) {
            this.links = type;
            return this;
        }

        public UssChangeModeInputData build() {
            return new UssChangeModeInputData(this);
        }
    }
}

