/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.input;

import java.util.Optional;
import java.util.OptionalInt;

public class UssGetInputData {
    private final String search;
    private final String research;
    private final boolean insensitive;
    private final Integer maxreturnsize;
    private final int queryCount;
    private final boolean binary;
    private final String recordsRange;

    public UssGetInputData(Builder builder) {
        this.search = builder.search;
        this.research = builder.research;
        this.insensitive = builder.insensitive;
        this.maxreturnsize = builder.maxreturnsize;
        this.queryCount = builder.queryCount;
        this.binary = builder.binary;
        this.recordsRange = builder.recordsRange;
    }

    public Optional<String> getSearch() {
        return Optional.ofNullable(this.search);
    }

    public Optional<String> getResearch() {
        return Optional.ofNullable(this.research);
    }

    public boolean isInsensitive() {
        return this.insensitive;
    }

    public OptionalInt getMaxReturnSize() {
        return this.maxreturnsize == null ? OptionalInt.empty() : OptionalInt.of(this.maxreturnsize);
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public Optional<String> getRecordsRange() {
        return Optional.ofNullable(this.recordsRange);
    }

    public String toString() {
        return "UssGetInputData{search=" + this.search + ", research=" + this.research + ", insensitive=" + this.insensitive + ", maxreturnsize=" + this.maxreturnsize + ", queryCount=" + this.queryCount + ", binary=" + this.binary + ", queryCount=" + this.queryCount + ", recordsRange=" + this.recordsRange + "}";
    }

    public static class Builder {
        private String search;
        private String research;
        private boolean insensitive = true;
        private Integer maxreturnsize;
        private int queryCount = 0;
        private boolean binary = false;
        private String recordsRange;

        public Builder search(String search) {
            if (this.research != null) {
                throw new IllegalStateException("cannot specify both search and research parameters");
            }
            this.search = search;
            ++this.queryCount;
            return this;
        }

        public Builder research(String research) {
            if (this.search != null) {
                throw new IllegalStateException("cannot specify both search and research parameters");
            }
            this.research = research;
            ++this.queryCount;
            return this;
        }

        public Builder insensitive(boolean insensitive) {
            this.insensitive = insensitive;
            ++this.queryCount;
            return this;
        }

        public Builder maxreturnsize(int maxreturnsize) {
            this.maxreturnsize = maxreturnsize;
            ++this.queryCount;
            return this;
        }

        public Builder binary(boolean binary) {
            this.binary = binary;
            return this;
        }

        public Builder recordsRange(String recordsRange) {
            this.recordsRange = recordsRange;
            return this;
        }

        public UssGetInputData build() {
            return new UssGetInputData(this);
        }
    }
}

