/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosfiles.uss.methods;

import java.util.HashMap;
import org.json.simple.JSONObject;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.PutJsonZosmfRequest;
import zowe.client.sdk.rest.Response;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.EncodeUtils;
import zowe.client.sdk.utility.FileUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosfiles.uss.input.UssChangeTagInputData;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagAction;
import zowe.client.sdk.zosfiles.uss.types.ChangeTagType;

public class UssChangeTag {
    private final ZosConnection connection;
    private ZosmfRequest request;

    public UssChangeTag(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    UssChangeTag(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof PutJsonZosmfRequest)) {
            throw new IllegalStateException("PUT_JSON request type required");
        }
        this.request = request;
    }

    public Response binary(String fileNamePath) throws ZosmfRequestException {
        return this.changeCommon(fileNamePath, new UssChangeTagInputData.Builder().action(ChangeTagAction.SET).type(ChangeTagType.BINARY).build());
    }

    public Response text(String fileNamePath, String codeSet) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fileNamePath, "fileNamePath");
        ValidateUtils.checkIllegalParameter(codeSet, "codeSet");
        return this.changeCommon(fileNamePath, new UssChangeTagInputData.Builder().action(ChangeTagAction.SET).type(ChangeTagType.TEXT).codeset(codeSet).build());
    }

    public Response remove(String fileNamePath) throws ZosmfRequestException {
        return this.changeCommon(fileNamePath, new UssChangeTagInputData.Builder().action(ChangeTagAction.REMOVE).build());
    }

    public Response get(String fileNamePath) throws ZosmfRequestException {
        return this.changeCommon(fileNamePath, new UssChangeTagInputData.Builder().action(ChangeTagAction.LIST).build());
    }

    public Response changeCommon(String fileNamePath, UssChangeTagInputData changeTagInputData) throws ZosmfRequestException {
        ValidateUtils.checkIllegalParameter(fileNamePath, "fileNamePath");
        ValidateUtils.checkNullParameter(changeTagInputData == null, "changeTagInputData is null");
        ValidateUtils.checkIllegalParameter(changeTagInputData.getAction().isEmpty(), "action not specified");
        String url = this.connection.getZosmfUrl() + "/restfiles/fs" + EncodeUtils.encodeURIComponent(FileUtils.validatePath(fileNamePath));
        HashMap<String, String> changeTagMap = new HashMap<String, String>();
        changeTagMap.put("request", "chtag");
        changeTagMap.put("action", changeTagInputData.getAction().get().getValue());
        changeTagInputData.getType().ifPresent(type -> changeTagMap.put("type", type.getValue()));
        changeTagInputData.getCodeset().ifPresent(codeset -> changeTagMap.put("codeset", (String)codeset));
        if (!changeTagInputData.isRecursive()) {
            changeTagMap.put("recursive", "false");
        }
        changeTagInputData.getLinks().ifPresent(links -> changeTagMap.put("links", links.getValue()));
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.PUT_JSON);
        }
        this.request.setUrl(url);
        this.request.setBody(new JSONObject(changeTagMap).toString());
        return this.request.executeRequest();
    }
}

