/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosjobs.input;

import java.util.Optional;
import java.util.OptionalInt;
import zowe.client.sdk.zosjobs.types.JobStatus;

public class JobMonitorInputData {
    private final String jobId;
    private final String jobName;
    private Integer watchDelay;
    private JobStatus.Type jobStatus;
    private Integer attempts;
    private Integer lineLimit;

    private JobMonitorInputData(Builder builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.watchDelay = builder.watchDelay;
        this.jobStatus = builder.jobStatus;
        this.attempts = builder.attempts;
        this.lineLimit = builder.lineLimit;
    }

    public OptionalInt getAttempts() {
        return this.attempts == null ? OptionalInt.empty() : OptionalInt.of(this.attempts);
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public Optional<String> getJobId() {
        return Optional.ofNullable(this.jobId);
    }

    public Optional<String> getJobName() {
        return Optional.ofNullable(this.jobName);
    }

    public Optional<JobStatus.Type> getJobStatus() {
        return Optional.ofNullable(this.jobStatus);
    }

    public void setJobStatus(JobStatus.Type jobStatus) {
        this.jobStatus = jobStatus;
    }

    public OptionalInt getLineLimit() {
        return this.lineLimit == null ? OptionalInt.empty() : OptionalInt.of(this.lineLimit);
    }

    public void setLineLimit(int lineLimit) {
        this.lineLimit = lineLimit;
    }

    public OptionalInt getWatchDelay() {
        return this.watchDelay == null ? OptionalInt.empty() : OptionalInt.of(this.watchDelay);
    }

    public void setWatchDelay(int watchDelay) {
        this.watchDelay = watchDelay;
    }

    public String toString() {
        return "JobMonitorInputData{jobId=" + this.jobId + ", jobName=" + this.jobName + ", watchDelay=" + this.watchDelay + ", jobStatus=" + this.jobStatus + ", attempts=" + this.attempts + ", lineLimit=" + this.lineLimit + "}";
    }

    public static class Builder {
        private final String jobId;
        private final String jobName;
        private Integer watchDelay;
        private JobStatus.Type jobStatus;
        private Integer attempts;
        private Integer lineLimit;

        public Builder(String jobName, String jobId) {
            this.jobName = jobName;
            this.jobId = jobId;
        }

        public Builder attempts(int attempts) {
            this.attempts = attempts;
            return this;
        }

        public Builder jobStatus(JobStatus.Type jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder lineLimit(int lineLimit) {
            this.lineLimit = lineLimit;
            return this;
        }

        public Builder watchDelay(int watchDelay) {
            this.watchDelay = watchDelay;
            return this;
        }

        public JobMonitorInputData build() {
            return new JobMonitorInputData(this);
        }
    }
}

