/*
 * Decompiled with CFR 0.152.
 */
package zowe.client.sdk.zosmfinfo.methods;

import java.util.Optional;
import java.util.stream.IntStream;
import kong.unirest.core.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zowe.client.sdk.core.ZosConnection;
import zowe.client.sdk.rest.GetJsonZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequest;
import zowe.client.sdk.rest.ZosmfRequestFactory;
import zowe.client.sdk.rest.exception.ZosmfRequestException;
import zowe.client.sdk.rest.type.ZosmfRequestType;
import zowe.client.sdk.utility.JsonUtils;
import zowe.client.sdk.utility.ValidateUtils;
import zowe.client.sdk.zosmfinfo.model.ZosmfPlugin;
import zowe.client.sdk.zosmfinfo.response.ZosmfInfoResponse;

public class ZosmfStatus {
    private static final Logger LOG = LoggerFactory.getLogger(ZosmfStatus.class);
    private final ZosConnection connection;
    private ZosmfRequest request;

    public ZosmfStatus(ZosConnection connection) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        this.connection = connection;
    }

    ZosmfStatus(ZosConnection connection, ZosmfRequest request) {
        ValidateUtils.checkNullParameter(connection == null, "connection is null");
        ValidateUtils.checkNullParameter(request == null, "request is null");
        this.connection = connection;
        if (!(request instanceof GetJsonZosmfRequest)) {
            throw new IllegalStateException("GET_JSON request type required");
        }
        this.request = request;
    }

    public ZosmfInfoResponse get() throws ZosmfRequestException {
        String url = this.connection.getZosmfUrl() + "/info";
        if (this.request == null) {
            this.request = ZosmfRequestFactory.buildRequest(this.connection, ZosmfRequestType.GET_JSON);
        }
        this.request.setUrl(url);
        String responsePhrase = this.request.executeRequest().getResponsePhrase().orElseThrow(() -> new IllegalStateException("no z/osmf status response phrase")).toString();
        ZosmfInfoResponse response = JsonUtils.parseResponse(responsePhrase, ZosmfInfoResponse.class, "get");
        JSONObject jsonStr = new JSONObject(responsePhrase);
        Optional.ofNullable(jsonStr.optJSONArray("plugins")).ifPresent(plugins -> {
            ZosmfPlugin[] zosmfPluginsInfo = (ZosmfPlugin[])IntStream.range(0, plugins.length()).mapToObj(i -> this.safeParse(String.valueOf(plugins.get(i)), ZosmfPlugin.class)).filter(Optional::isPresent).map(Optional::get).toArray(ZosmfPlugin[]::new);
            response.withZosmfPluginsInfo(zosmfPluginsInfo);
        });
        if (response.getZosmfPluginsInfo() == null) {
            return response.withZosmfPluginsInfo(new ZosmfPlugin[0]);
        }
        return response;
    }

    private <T> Optional<T> safeParse(String responseString, Class<T> classs) {
        try {
            return Optional.ofNullable(JsonUtils.parseResponse(responseString, classs, "get"));
        }
        catch (Exception e) {
            LOG.error("Failed to parse response: {}", (Object)responseString, (Object)e);
            return Optional.empty();
        }
    }
}

