/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.client.Broker;
import org.zstacks.zbus.client.MqAdmin;
import org.zstacks.zbus.client.MqConfig;
import org.zstacks.zbus.protocol.MessageMode;
import org.zstacks.znet.Message;
import org.zstacks.znet.RemotingClient;
import org.zstacks.znet.callback.MessageCallback;

public class Consumer
extends MqAdmin
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Consumer.class);
    private RemotingClient client;
    private String topic = null;
    private int messageCallbackThreadCount = 4;
    protected ExecutorService executorService = null;
    private MessageCallback callback;

    public Consumer(Broker broker, String mq, MessageMode ... mode) {
        super(broker, mq, mode);
    }

    public Consumer(MqConfig config) {
        super(config);
        this.topic = config.getTopic();
    }

    public Message recv(int timeout) throws IOException, InterruptedException {
        if (this.client == null) {
            this.client = this.broker.getClient(this.myClientHint());
        }
        Message req = new Message();
        req.setCommand("consume");
        req.setMq(this.mq);
        req.setToken(this.accessToken);
        if (MessageMode.isEnabled(this.mode, MessageMode.PubSub) && this.topic != null) {
            req.setTopic(this.topic);
        }
        Message res = null;
        try {
            res = this.client.invokeSync(req, timeout);
            if (res != null && res.isStatus404()) {
                if (!this.createMQ()) {
                    throw new IllegalStateException("register error");
                }
                return this.recv(timeout);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                this.broker.closeClient(this.client);
                this.client = this.broker.getClient(this.myClientHint());
            }
            catch (IOException ex) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.broker.closeClient(this.client);
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Override
    protected Message invokeCreateMQ(Message req) throws IOException, InterruptedException {
        if (this.client == null) {
            this.client = this.broker.getClient(this.myClientHint());
        }
        return this.client.invokeSync(req, this.invokeTimeout);
    }

    public void reply(Message msg) throws IOException {
        if (msg.getStatus() != null) {
            msg.setReplyCode(msg.getStatus());
        }
        msg.setCommand("produce");
        msg.setAck(false);
        this.client.getSession().write((Object)msg);
    }

    public void onMessage(MessageCallback cb) throws IOException {
        this.callback = cb;
        if (this.executorService != null) {
            return;
        }
        this.executorService = new ThreadPoolExecutor(this.messageCallbackThreadCount, 256, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            Message msg;
                            try {
                                msg = Consumer.this.recv(10000);
                            }
                            catch (InterruptedException e) {
                                break block4;
                            }
                            if (msg == null) continue;
                            Consumer.this.callback.onMessage(msg, Consumer.this.client.getSession());
                        }
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        if (!MessageMode.isEnabled(this.mode, MessageMode.PubSub)) {
            throw new IllegalStateException("topic support for none-PubSub mode");
        }
        this.topic = topic;
    }

    public int getMessageCallbackThreadCount() {
        return this.messageCallbackThreadCount;
    }

    public void setMessageCallbackThreadCount(int messageCallbackThreadCount) {
        this.messageCallbackThreadCount = messageCallbackThreadCount;
    }
}

