/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client;

import java.io.IOException;
import java.util.HashMap;
import org.zstacks.zbus.client.Broker;
import org.zstacks.zbus.client.ClientHint;
import org.zstacks.zbus.client.MqConfig;
import org.zstacks.zbus.protocol.MessageMode;
import org.zstacks.zbus.protocol.Proto;
import org.zstacks.znet.Message;

public class MqAdmin {
    protected final Broker broker;
    protected String mq;
    protected String accessToken = "";
    protected String registerToken = "";
    protected int mode;
    protected int invokeTimeout = 2500;

    public MqAdmin(Broker broker, String mq, MessageMode ... mode) {
        this.broker = broker;
        this.mq = mq;
        this.mode = mode.length == 0 ? MessageMode.intValue(MessageMode.MQ) : MessageMode.intValue(mode);
    }

    public MqAdmin(MqConfig config) {
        this.broker = config.getBroker();
        this.mq = config.getMq();
        this.accessToken = config.getAccessToken();
        this.registerToken = config.getRegisterToken();
        this.mode = config.getMode();
    }

    protected ClientHint myClientHint() {
        ClientHint hint = new ClientHint();
        hint.setMq(this.mq);
        return hint;
    }

    protected Message invokeCreateMQ(Message req) throws IOException, InterruptedException {
        return this.broker.invokeSync(req, this.invokeTimeout);
    }

    public boolean createMQ() throws IOException, InterruptedException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mqName", this.mq);
        params.put("accessToken", this.accessToken);
        params.put("mqMode", "" + this.mode);
        Message req = Proto.buildSubCommandMessage("admin", "create_mq", params);
        req.setToken(this.registerToken);
        req.setMq(this.mq);
        Message res = this.invokeCreateMQ(req);
        if (res == null) {
            return false;
        }
        return res.isStatus200();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRegisterToken() {
        return this.registerToken;
    }

    public void setRegisterToken(String registerToken) {
        this.registerToken = registerToken;
    }

    public String getMq() {
        return this.mq;
    }

    public void setMq(String mq) {
        this.mq = mq;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public void setInvokeTimeout(int invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
    }
}

