/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.broker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.client.broker.TrackListener;
import org.zstacks.zbus.protocol.TrackTable;
import org.zstacks.znet.Message;
import org.zstacks.znet.RemotingClient;
import org.zstacks.znet.callback.ErrorCallback;
import org.zstacks.znet.callback.MessageCallback;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.nio.Session;
import org.zstacks.znet.ticket.ResultCallback;

public class TrackAgent
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TrackAgent.class);
    private String trackServerList = "127.0.0.1:16666";
    private final List<RemotingClient> clients = new ArrayList<RemotingClient>();
    private Dispatcher dispatcher;
    private CountDownLatch tableReady = new CountDownLatch(1);
    private List<TrackListener> trackListeners = new ArrayList<TrackListener>();

    public TrackAgent(String trackServerList, Dispatcher dispatcher) throws IOException {
        this.dispatcher = dispatcher;
        this.connectToTrackServers();
    }

    public void waitForReady(long timeout) {
        try {
            this.tableReady.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addTrackListener(TrackListener listener) {
        this.trackListeners.add(listener);
    }

    public void removeTrackListener(TrackListener listener) {
        this.trackListeners.remove(listener);
    }

    private void connectToTrackServers() {
        String[] serverAddrs;
        for (String addr : serverAddrs = this.trackServerList.split("[;]")) {
            if ((addr = addr.trim()).length() == 0) continue;
            final RemotingClient client = new RemotingClient(addr, this.dispatcher);
            this.clients.add(client);
            this.dispatcher.asyncRun(new Runnable(){

                @Override
                public void run() {
                    try {
                        TrackAgent.this.initTrackClient(client);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void initTrackClient(final RemotingClient client) throws IOException {
        client.setMessageCallback(new MessageCallback(){

            public void onMessage(Message msg, Session sess) throws IOException {
                TrackTable trackTable = (TrackTable)JSON.parseObject((byte[])msg.getBody(), TrackTable.class, (Feature[])new Feature[0]);
                for (TrackListener listener : TrackAgent.this.trackListeners) {
                    listener.onTrackTableUpdated(trackTable);
                }
                TrackAgent.this.tableReady.countDown();
            }
        });
        client.setErrorCallback(new ErrorCallback(){

            public void onError(IOException e, Session sess) throws IOException {
                TrackAgent.this.dispatcher.asyncRun(new Runnable(){

                    @Override
                    public void run() {
                        TrackAgent.this.doTrackSub(client);
                    }
                });
            }
        });
        this.doTrackSub(client);
    }

    private void doTrackSub(RemotingClient client) {
        try {
            Message msg = new Message();
            msg.setCommand("track_sub");
            client.invokeAsync(msg, new ResultCallback(){

                public void onCompleted(Message result) {
                    TrackTable trackTable = (TrackTable)JSON.parseObject((byte[])result.getBody(), TrackTable.class, (Feature[])new Feature[0]);
                    for (TrackListener listener : TrackAgent.this.trackListeners) {
                        listener.onTrackTableUpdated(trackTable);
                    }
                    TrackAgent.this.tableReady.countDown();
                }
            });
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        for (RemotingClient client : this.clients) {
            client.close();
        }
    }
}

