/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.rpc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.zstacks.zbus.client.ZbusException;
import org.zstacks.zbus.client.rpc.Codec;
import org.zstacks.zbus.client.rpc.Request;
import org.zstacks.zbus.client.rpc.Response;
import org.zstacks.znet.Message;

public class JsonCodec
implements Codec {
    private static final String DEFAULT_ENCODING = "UTF-8";

    @Override
    public Message encodeRequest(Request request) {
        Message msg = new Message();
        String encoding = request.getEncoding();
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        msg.setBody(JsonCodec.toJSONBytes(request, encoding, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteClassName));
        return msg;
    }

    @Override
    public Request decodeRequest(Message msg) {
        String encoding = msg.getEncoding();
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        String jsonString = msg.getBodyString(encoding);
        Request req = (Request)JSON.parseObject((String)jsonString, Request.class);
        return req;
    }

    @Override
    public Object normalize(Object param, Class<?> targetType) throws ClassNotFoundException {
        if (param instanceof JSON) {
            return JSON.toJavaObject((JSON)((JSON)param), targetType);
        }
        if (targetType.getName().equals("java.lang.Class")) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(param.toString());
        }
        return param;
    }

    @Override
    public Message encodeResponse(Response response) {
        String encoding;
        Message msg = new Message();
        msg.setStatus("200");
        if (response.getError() != null) {
            Throwable error = response.getError();
            if (error instanceof IllegalArgumentException) {
                msg.setStatus("400");
            } else {
                msg.setStatus("500");
            }
        }
        if ((encoding = response.getEncoding()) == null) {
            encoding = DEFAULT_ENCODING;
        }
        msg.setBody(JsonCodec.toJSONBytes(response, encoding, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteClassName));
        return msg;
    }

    @Override
    public Response decodeResponse(Message msg) {
        Response res;
        block7: {
            String encoding = msg.getEncoding();
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            }
            String jsonString = msg.getBodyString(encoding);
            res = null;
            try {
                res = (Response)JSON.parseObject((String)jsonString, Response.class);
            }
            catch (Exception e) {
                res = new Response();
                JSONObject json = null;
                try {
                    jsonString = jsonString.replace("@type", "unknown-class");
                    json = JSON.parseObject((String)jsonString);
                }
                catch (Exception ex) {
                    String prefix = "";
                    if (msg.isStatus200()) {
                        prefix = "JSON format invalid: ";
                    }
                    throw new ZbusException(prefix + jsonString);
                }
                if (json == null) break block7;
                String stackTrace = "stackTrace";
                if (json.containsKey((Object)"stackTrace")) {
                    throw new ZbusException(json.getString("stackTrace"));
                }
                res.setResult(json.get((Object)"result"));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] toJSONBytes(Object object, String charsetName, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            for (SerializerFeature feature : features) {
                serializer.config(feature, true);
            }
            serializer.write(object);
            byte[] byArray = out.toBytes(charsetName);
            return byArray;
        }
        finally {
            out.close();
        }
    }
}

