/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.rpc;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.client.Broker;
import org.zstacks.zbus.client.ZbusException;
import org.zstacks.zbus.client.rpc.Codec;
import org.zstacks.zbus.client.rpc.JsonCodec;
import org.zstacks.zbus.client.rpc.Request;
import org.zstacks.zbus.client.rpc.Response;
import org.zstacks.zbus.client.rpc.RpcConfig;
import org.zstacks.zbus.client.service.Caller;
import org.zstacks.zbus.protocol.MessageMode;
import org.zstacks.znet.Message;

public class Rpc
extends Caller {
    private static final Logger log = LoggerFactory.getLogger(Rpc.class);
    private static final Codec codec = new JsonCodec();
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String module = "";
    private String encoding = "UTF-8";
    private int timeout = 10000;

    public Rpc(Broker broker, String mq) {
        super(broker, mq, new MessageMode[0]);
    }

    public Rpc(RpcConfig config) {
        super(config);
        this.module = config.getModule();
        this.timeout = config.getTimeout();
        this.encoding = config.getEncoding();
    }

    public <T> T invokeSync(Class<T> clazz, String method, Object ... args) {
        Object netObj = this.invokeSync(method, args);
        try {
            return (T)codec.normalize(netObj, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ZbusException(e.getMessage(), e.getCause());
        }
    }

    public <T> T invokeSyncWithType(Class<T> clazz, String method, Class<?>[] types, Object ... args) {
        Object netObj = this.invokeSyncWithType(method, types, args);
        try {
            return (T)codec.normalize(netObj, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ZbusException(e.getMessage(), e.getCause());
        }
    }

    public Object invokeSync(String method, Object ... args) {
        return this.invokeSyncWithType(method, null, args);
    }

    public Object invokeSyncWithType(String method, Class<?>[] types, Object ... args) {
        Request req = new Request();
        req.setModule(this.module);
        req.setMethod(method);
        req.setParams(args);
        req.assignParamTypes(types);
        req.setEncoding(this.encoding);
        Message msg = null;
        try {
            msg = codec.encodeRequest(req);
            log.debug("Request: {}", (Object)msg);
            msg = this.invokeSync(msg, this.timeout);
            log.debug("Response: {}", (Object)msg);
        }
        catch (IOException e) {
            throw new ZbusException(e.getMessage(), e);
        }
        if (msg == null) {
            String errorMsg = String.format("method(%s) request timeout", method);
            throw new ZbusException(errorMsg);
        }
        Response resp = codec.decodeResponse(msg);
        if (resp.getStackTrace() != null) {
            Throwable error = resp.getError();
            if (error != null) {
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new ZbusException(error.getMessage(), error.getCause());
            }
            throw new ZbusException(resp.getStackTrace());
        }
        return resp.getResult();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public Rpc module(String module) {
        this.module = module;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

