/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.zstacks.zbus.client.rpc.Rpc;

class RpcInvoker
implements InvocationHandler {
    private Rpc rpc;
    private static final Object REMOTE_METHOD_CALL = new Object();

    public RpcInvoker(Rpc rpc) {
        this.rpc = rpc;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value;
        if (args == null) {
            args = new Object[]{};
        }
        if ((value = this.handleLocalMethod(proxy, method, args)) != REMOTE_METHOD_CALL) {
            return value;
        }
        Class<?> returnType = method.getReturnType();
        return this.rpc.invokeSyncWithType(returnType, method.getName(), method.getParameterTypes(), args);
    }

    protected Object handleLocalMethod(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value0 = args[0];
            if (value0 == null || !Proxy.isProxyClass(value0.getClass())) {
                return new Boolean(false);
            }
            RpcInvoker handler = (RpcInvoker)Proxy.getInvocationHandler(value0);
            return new Boolean(this.rpc.equals(handler.rpc));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this.rpc.hashCode());
        }
        if (methodName.equals("toString") && params.length == 0) {
            return "RpcInvoker[" + this.rpc + "]";
        }
        return REMOTE_METHOD_CALL;
    }
}

