/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.rpc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.client.Broker;
import org.zstacks.zbus.client.rpc.Rpc;
import org.zstacks.zbus.client.rpc.RpcConfig;
import org.zstacks.zbus.client.rpc.RpcInvoker;

public class RpcProxy {
    private static final Logger log = LoggerFactory.getLogger(RpcProxy.class);
    private static Constructor<RpcInvoker> rpcInvokerCtor;
    private Map<String, RpcInvoker> rpcInvokerCache = new ConcurrentHashMap<String, RpcInvoker>();
    private final Broker broker;

    public RpcProxy(Broker broker) {
        this.broker = broker;
    }

    public <T> T getService(Class<T> api, String serviceUrl) throws Exception {
        RpcConfig config = RpcProxy.parseRpcConfig(serviceUrl);
        return this.getService(api, config);
    }

    public <T> T getService(Class<T> api, RpcConfig config) throws Exception {
        config.setBroker(this.broker);
        String mq = config.getMq();
        if (mq == null) {
            throw new IllegalArgumentException("Missing argument mq");
        }
        String module = config.getModule();
        if (module == null || module.trim().length() == 0) {
            module = api.getSimpleName();
            config.setModule(module);
        }
        String encoding = config.getEncoding();
        int timeout = config.getTimeout();
        String accessToken = config.getAccessToken();
        String registerToken = config.getRegisterToken();
        String cacheKey = String.format("mq=%s&&module=%s&&encoding=%s&&timeout=%d&&accessToken=%s&&registerToken=%s", mq, module, encoding, timeout, accessToken, registerToken);
        RpcInvoker rpcInvoker = this.rpcInvokerCache.get(cacheKey);
        Class[] interfaces = new Class[]{api};
        if (rpcInvoker == null) {
            Rpc rpc = new Rpc(config);
            rpcInvoker = rpcInvokerCtor.newInstance(rpc);
            this.rpcInvokerCache.put(cacheKey, rpcInvoker);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)rpcInvoker);
    }

    private static RpcConfig parseRpcConfig(String kvstring) {
        String[] parts;
        RpcConfig config = new RpcConfig();
        for (String kv : parts = kvstring.split("\\&")) {
            String[] kvp = kv.split("=");
            String key = kvp[0].trim();
            String val = "";
            if (kvp.length > 1) {
                val = kvp[1].trim();
            }
            if ("mq".equals(key)) {
                config.setMq(val);
                continue;
            }
            if ("encoding".equals(key)) {
                config.setEncoding(val);
                continue;
            }
            if ("mode".equals(key)) {
                int timeout = 2500;
                try {
                    timeout = Integer.valueOf(val);
                }
                catch (Exception e) {
                    // empty catch block
                }
                config.setTimeout(timeout);
                continue;
            }
            if ("accessToken".equals(key)) {
                config.setAccessToken(val);
                continue;
            }
            if ("registerToken".equals(key)) {
                config.setRegisterToken(val);
                continue;
            }
            if ("topic".equals(key)) {
                config.setTopic(val);
                continue;
            }
            if (!"mode".equals(key)) continue;
            int mode = 0;
            try {
                mode = Integer.valueOf(val);
            }
            catch (Exception e) {
                // empty catch block
            }
            config.setMode(mode);
        }
        return config;
    }

    static {
        try {
            rpcInvokerCtor = RpcInvoker.class.getConstructor(Rpc.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

