/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.service;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.client.service.ServiceConfig;
import org.zstacks.zbus.client.service.WorkerThread;

public class Service
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Service.class);
    private final ServiceConfig config;
    private WorkerThread[] workerThreads;

    public Service(ServiceConfig config) {
        this.config = config;
        if (config.getMq() == null || "".equals(config.getMq())) {
            throw new IllegalArgumentException("MQ required");
        }
        if (config.getServiceHandler() == null) {
            throw new IllegalArgumentException("serviceHandler required");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.workerThreads != null) {
            for (WorkerThread thread : this.workerThreads) {
                try {
                    thread.close();
                }
                catch (IOException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void start() {
        this.workerThreads = new WorkerThread[this.config.getThreadCount()];
        for (int i = 0; i < this.workerThreads.length; ++i) {
            WorkerThread thread;
            this.workerThreads[i] = thread = new WorkerThread(this.config);
            this.workerThreads[i].start();
        }
    }
}

