/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.client.service;

import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.client.Consumer;
import org.zstacks.zbus.client.service.ServiceConfig;
import org.zstacks.znet.Message;

class WorkerThread
extends Thread
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(WorkerThread.class);
    private ServiceConfig config = null;
    private Consumer consumer;

    public WorkerThread(ServiceConfig config) {
        this.config = config;
    }

    @Override
    public void run() {
        this.consumer = new Consumer(this.config);
        int timeout = this.config.getReadTimeout();
        while (!this.isInterrupted()) {
            try {
                Message msg = this.consumer.recv(timeout);
                if (msg == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Request: {}", (Object)msg);
                }
                String mqReply = msg.getMqReply();
                String msgId = msg.getMsgIdRaw();
                Message res = this.config.getServiceHandler().handleRequest(msg);
                if (res == null) continue;
                res.setMsgId(msgId);
                res.setMq(mqReply);
                this.consumer.reply(res);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("Service thread({}) closed", (Object)this.getId());
        if (this.consumer != null) {
            try {
                this.consumer.close();
                this.consumer = null;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.interrupt();
    }
}

