/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.protocol;

import java.util.List;
import org.zstacks.zbus.protocol.ConsumerInfo;

public class MqInfo {
    private String broker;
    private String name;
    private int mode;
    private String creator;
    private long createdTime;
    private long unconsumedMsgCount;
    private List<ConsumerInfo> consumerInfoList;

    public String getBroker() {
        return this.broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public long getUnconsumedMsgCount() {
        return this.unconsumedMsgCount;
    }

    public void setUnconsumedMsgCount(long unconsumedMsgCount) {
        this.unconsumedMsgCount = unconsumedMsgCount;
    }

    public int getConsumerCount() {
        if (this.consumerInfoList == null) {
            return 0;
        }
        return this.consumerInfoList.size();
    }

    public List<ConsumerInfo> getConsumerInfoList() {
        return this.consumerInfoList;
    }

    public void setConsumerInfoList(List<ConsumerInfo> consumerInfoList) {
        this.consumerInfoList = consumerInfoList;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public double getLoadFactor() {
        if (this.consumerInfoList == null || this.consumerInfoList.size() == 0) {
            return Double.MAX_VALUE;
        }
        return 1.0 * ((double)this.unconsumedMsgCount + 1.0E-6) / (double)this.consumerInfoList.size();
    }

    public String toString() {
        return "MqInfo [broker=" + this.broker + ", name=" + this.name + ", mode=" + this.mode + ", creator=" + this.creator + ", createdTime=" + this.createdTime + ", unconsumedMsgCount=" + this.unconsumedMsgCount + ", consumerInfoList=" + this.consumerInfoList + "]";
    }
}

