/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.zstacks.zbus.protocol.BrokerInfo;
import org.zstacks.zbus.protocol.MqInfo;

public class TrackTable {
    private Map<String, BrokerInfo> brokerTable = new ConcurrentHashMap<String, BrokerInfo>();
    private Map<String, List<MqInfo>> mqTable = new ConcurrentHashMap<String, List<MqInfo>>();

    public Map<String, BrokerInfo> getBrokerTable() {
        return this.brokerTable;
    }

    public Set<String> brokerAddresses() {
        return this.brokerTable.keySet();
    }

    public Map<String, List<MqInfo>> getMqTable() {
        return this.mqTable;
    }

    public void sortMqTable() {
        this.mqTable.clear();
        for (Map.Entry<String, BrokerInfo> entry : this.brokerTable.entrySet()) {
            BrokerInfo brokerInfo = entry.getValue();
            for (Map.Entry<String, MqInfo> e : brokerInfo.getMqTable().entrySet()) {
                String mqName = e.getKey();
                MqInfo mqInfo = e.getValue();
                List<MqInfo> mqInfos = this.mqTable.get(mqName);
                if (mqInfos == null) {
                    mqInfos = new ArrayList<MqInfo>();
                    this.mqTable.put(mqName, mqInfos);
                }
                mqInfos.add(mqInfo);
            }
        }
        for (List<MqInfo> mqInfos : this.mqTable.values()) {
            Collections.sort(mqInfos, new Comparator<MqInfo>(){

                @Override
                public int compare(MqInfo m1, MqInfo m2) {
                    double f2;
                    double f1 = m1.getLoadFactor();
                    if (f1 < (f2 = m2.getLoadFactor())) {
                        return 1;
                    }
                    if (f1 == f2) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
    }

    public void addBroker(String brokerAddress, BrokerInfo info) {
        this.brokerTable.put(brokerAddress, info);
        this.sortMqTable();
    }

    public void removeBroker(String brokerAddress) {
        this.brokerTable.remove(brokerAddress);
        this.sortMqTable();
    }

    public List<MqInfo> getMqInfo(String mq) {
        return this.mqTable.get(mq);
    }

    public void setBrokerTable(Map<String, BrokerInfo> brokerTable) {
        this.brokerTable = brokerTable;
        this.sortMqTable();
    }

    public void setMqTable(Map<String, List<MqInfo>> mqTable) {
        this.mqTable = mqTable;
        this.sortMqTable();
    }

    public String toString() {
        return "TrackTable [brokerTable=" + this.brokerTable + ", mqTable=" + this.mqTable + "]";
    }
}

