/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.protocol.MessageMode;
import org.zstacks.zbus.server.ServerHelper;
import org.zstacks.zbus.server.SubCommandHandler;
import org.zstacks.zbus.server.TrackReport;
import org.zstacks.zbus.server.mq.MessageQueue;
import org.zstacks.zbus.server.mq.PubsubQueue;
import org.zstacks.zbus.server.mq.RequestQueue;
import org.zstacks.zbus.server.mq.store.MessageStore;
import org.zstacks.znet.Helper;
import org.zstacks.znet.Message;
import org.zstacks.znet.MessageHandler;
import org.zstacks.znet.nio.Session;

public class AdminHandler
extends SubCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(AdminHandler.class);
    private final ConcurrentMap<String, MessageQueue> mqTable;
    private final ExecutorService executorService;
    private final String serverAddr;
    private final TrackReport trackReport;
    private MessageStore messageStore = null;

    public AdminHandler(ConcurrentMap<String, MessageQueue> mqTable, ExecutorService executorService, String serverAddr, TrackReport trackReport) {
        this.mqTable = mqTable;
        this.executorService = executorService;
        this.serverAddr = serverAddr;
        this.trackReport = trackReport;
        this.initCommands();
    }

    private void initCommands() {
        this.registerHandler("create_mq", new MessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg, Session sess) throws IOException {
                JSONObject params = null;
                try {
                    params = JSON.parseObject((String)msg.getBodyString());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    msg.setBody("register param json body invalid");
                    ServerHelper.reply400(msg, sess);
                    return;
                }
                String msgId = msg.getMsgId();
                String mqName = params.getString("mqName");
                String accessToken = params.getString("accessToken");
                String type = params.getString("mqMode");
                int mode = 0;
                try {
                    mode = Integer.valueOf(type);
                }
                catch (Exception e) {
                    msg.setBody("mqMode invalid");
                    ServerHelper.reply400(msg, sess);
                    return;
                }
                if (mqName == null) {
                    msg.setBody("Missing mq_name filed");
                    ServerHelper.reply400(msg, sess);
                    return;
                }
                MessageQueue mq = null;
                ConcurrentMap concurrentMap = AdminHandler.this.mqTable;
                synchronized (concurrentMap) {
                    mq = (MessageQueue)AdminHandler.this.mqTable.get(mqName);
                    if (mq == null) {
                        if (MessageMode.isEnabled(mode, MessageMode.PubSub)) {
                            mq = new PubsubQueue(AdminHandler.this.serverAddr, mqName, AdminHandler.this.executorService, mode);
                            mq.setAccessToken(accessToken);
                            mq.setCreator(sess.getRemoteAddress());
                        } else {
                            mq = new RequestQueue(AdminHandler.this.serverAddr, mqName, AdminHandler.this.executorService, mode);
                            mq.setMessageStore(AdminHandler.this.messageStore);
                            mq.setAccessToken(accessToken);
                            mq.setCreator(sess.getRemoteAddress());
                            if (AdminHandler.this.messageStore != null) {
                                AdminHandler.this.messageStore.onMessageQueueCreated(mq);
                            }
                        }
                        AdminHandler.this.mqTable.putIfAbsent(mqName, mq);
                        log.info("MQ Created: {}", (Object)mq);
                        ServerHelper.reply200(msgId, sess);
                        AdminHandler.this.trackReport.reportToTrackServer();
                        return;
                    }
                }
                if (MessageMode.isEnabled(mode, MessageMode.MQ) && !(mq instanceof RequestQueue)) {
                    msg.setBody("MsgQueue, type not matched");
                    ServerHelper.reply400(msg, sess);
                    return;
                }
                if (MessageMode.isEnabled(mode, MessageMode.PubSub) && !(mq instanceof PubsubQueue)) {
                    msg.setBody("Pubsub, type not matched");
                    ServerHelper.reply400(msg, sess);
                    return;
                }
                ServerHelper.reply200(msgId, sess);
            }
        });
        this.registerHandler("", new MessageHandler(){

            public void handleMessage(Message msg, Session sess) throws IOException {
                msg = new Message();
                msg.setStatus("200");
                msg.setHead("content-type", "text/html");
                String body = Helper.loadFileContent((String)"zbus.htm");
                msg.setBody(body);
                sess.write((Object)msg);
            }
        });
        this.registerHandler("jquery", new MessageHandler(){

            public void handleMessage(Message msg, Session sess) throws IOException {
                msg = new Message();
                msg.setStatus("200");
                msg.setHead("content-type", "application/javascript");
                String body = Helper.loadFileContent((String)"jquery.js");
                msg.setBody(body);
                sess.write((Object)msg);
            }
        });
        this.registerHandler("data", new MessageHandler(){

            public void handleMessage(Message msg, Session sess) throws IOException {
                msg = AdminHandler.this.trackReport.packServerInfo();
                msg.setStatus("200");
                msg.setHead("content-type", "application/json");
                sess.write((Object)msg);
            }
        });
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }
}

