/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.zstacks.zbus.server.ServerHelper;
import org.zstacks.znet.Message;
import org.zstacks.znet.MessageHandler;
import org.zstacks.znet.nio.Session;

class SubCommandHandler
implements MessageHandler {
    protected String accessToken = "";
    protected Map<String, MessageHandler> handlerMap = new ConcurrentHashMap<String, MessageHandler>();

    SubCommandHandler() {
    }

    public void registerHandler(String command, MessageHandler handler) {
        this.handlerMap.put(command, handler);
    }

    public void handleMessage(Message msg, Session sess) throws IOException {
        MessageHandler handler;
        if (!this.accessToken.equals("") && !this.accessToken.equals(msg.getToken())) {
            ServerHelper.reply403(msg, sess);
            return;
        }
        String subCmd = msg.getSubCommand();
        if (subCmd == null) {
            subCmd = "";
        }
        if ((handler = this.handlerMap.get(subCmd)) == null) {
            msg.setBody("sub_cmd=%s Not Found", new Object[]{subCmd});
            ServerHelper.reply404(msg, sess);
            return;
        }
        handler.handleMessage(msg, sess);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String value) {
        this.accessToken = value;
    }
}

