/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server;

import com.alibaba.fastjson.JSON;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.zstacks.zbus.protocol.BrokerInfo;
import org.zstacks.zbus.protocol.MqInfo;
import org.zstacks.zbus.server.mq.MessageQueue;
import org.zstacks.znet.Message;
import org.zstacks.znet.RemotingClient;
import org.zstacks.znet.callback.ErrorCallback;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.nio.Session;

public class TrackReport
implements Closeable {
    private long trackDelay = 1000L;
    private long trackInterval = 3000L;
    private final String zbusServerAddr;
    private final ConcurrentMap<String, MessageQueue> mqTable;
    private final List<RemotingClient> clients = new ArrayList<RemotingClient>();
    private final ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor();
    private ExecutorService reportService = new ThreadPoolExecutor(4, 16, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public TrackReport(ConcurrentMap<String, MessageQueue> mqTable, String zbusServerAddr) {
        this.mqTable = mqTable;
        this.zbusServerAddr = zbusServerAddr;
    }

    public void startTrackReport(String trackServerAddr, Dispatcher dispatcher) throws IOException {
        String[] serverAddrs;
        if (trackServerAddr == null) {
            return;
        }
        for (String addr : serverAddrs = trackServerAddr.split("[;]")) {
            if ((addr = addr.trim()).length() == 0) continue;
            RemotingClient client = new RemotingClient(addr, dispatcher);
            client.setErrorCallback(new ErrorCallback(){

                public void onError(IOException e, Session sess) throws IOException {
                }
            });
            this.clients.add(client);
        }
        this.scheduledService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TrackReport.this.reportToTrackServer();
            }
        }, this.trackDelay, this.trackInterval, TimeUnit.MILLISECONDS);
    }

    public Message packServerInfo() {
        HashMap<String, MqInfo> table = new HashMap<String, MqInfo>();
        for (Map.Entry e : this.mqTable.entrySet()) {
            table.put((String)e.getKey(), ((MessageQueue)e.getValue()).getMqInfo());
        }
        Message msg = new Message();
        BrokerInfo info = new BrokerInfo();
        info.setBroker(this.zbusServerAddr);
        info.setMqTable(table);
        msg.setBody(JSON.toJSONString((Object)info));
        return msg;
    }

    public void reportToTrackServer() {
        this.reportService.submit(new Runnable(){

            @Override
            public void run() {
                Message msg = TrackReport.this.packServerInfo();
                msg.setCommand("track_report");
                for (RemotingClient client : TrackReport.this.clients) {
                    try {
                        client.invokeAsync(msg, null);
                    }
                    catch (IOException e) {}
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        for (RemotingClient client : this.clients) {
            client.close();
        }
        this.scheduledService.shutdown();
        this.reportService.shutdown();
    }

    public long getTrackDelay() {
        return this.trackDelay;
    }

    public void setTrackDelay(long trackDelay) {
        this.trackDelay = trackDelay;
    }

    public long getTrackInterval() {
        return this.trackInterval;
    }

    public void setTrackInterval(long trackInterval) {
        this.trackInterval = trackInterval;
    }
}

