/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.protocol.BrokerInfo;
import org.zstacks.zbus.protocol.TrackTable;
import org.zstacks.znet.Helper;
import org.zstacks.znet.Message;
import org.zstacks.znet.MessageHandler;
import org.zstacks.znet.RemotingClient;
import org.zstacks.znet.RemotingServer;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.nio.Session;

public class TrackServer
extends RemotingServer {
    private static final Logger log = LoggerFactory.getLogger(TrackServer.class);
    private long publishInterval = 10000L;
    private long probeInterval = 3000L;
    private final TrackTable trackTable = new TrackTable();
    private Map<String, Session> subscribers = new ConcurrentHashMap<String, Session>();
    private Map<String, RemotingClient> brokerProbers = new ConcurrentHashMap<String, RemotingClient>();
    private final ScheduledExecutorService scheduledService = Executors.newSingleThreadScheduledExecutor();

    public TrackServer(int serverPort, Dispatcher dispatcher) throws IOException {
        this("0.0.0.0", serverPort, dispatcher);
    }

    public TrackServer(String serverHost, int serverPort, Dispatcher dispatcher) throws IOException {
        super(serverHost, serverPort, dispatcher);
        this.serverName = "TrackServer";
        this.scheduledService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TrackServer.this.publishTrackTable();
            }
        }, 0L, this.publishInterval, TimeUnit.MILLISECONDS);
        this.scheduledService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TrackServer.this.probeBrokers();
            }
        }, 0L, this.probeInterval, TimeUnit.MILLISECONDS);
        this.initHandlers();
    }

    private void probeBrokers() {
        Iterator<Map.Entry<String, RemotingClient>> iter = this.brokerProbers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, RemotingClient> entry = iter.next();
            String brokerAddress = entry.getKey();
            RemotingClient client = entry.getValue();
            if (client.hasConnected()) continue;
            this.trackTable.removeBroker(brokerAddress);
            iter.remove();
        }
        log.info("Track: " + this.trackTable);
    }

    private void publishTrackTable() {
        if (this.subscribers.size() < 1) {
            return;
        }
        String json = JSON.toJSONString((Object)this.trackTable);
        Message msg = new Message();
        msg.setCommand("track_pub");
        msg.setBody(json);
        Iterator<Map.Entry<String, Session>> iter = this.subscribers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Session> entry = iter.next();
            Session sess = entry.getValue();
            if (!sess.isActive()) {
                iter.remove();
                continue;
            }
            try {
                sess.write((Object)msg);
            }
            catch (IOException e) {
                iter.remove();
            }
        }
    }

    private void initHandlers() {
        this.registerHandler("track_report", new MessageHandler(){

            public void handleMessage(Message msg, Session sess) throws IOException {
                BrokerInfo brokerInfo = (BrokerInfo)JSON.parseObject((String)msg.getBodyString(), BrokerInfo.class);
                final String brokerAddress = brokerInfo.getBroker();
                if (!TrackServer.this.brokerProbers.containsKey(brokerAddress)) {
                    final RemotingClient client = new RemotingClient(brokerAddress, TrackServer.this.dispatcher);
                    TrackServer.this.dispatcher.asyncRun(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                client.connectIfNeed();
                                TrackServer.this.brokerProbers.put(brokerAddress, client);
                            }
                            catch (IOException e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                }
                TrackServer.this.trackTable.addBroker(brokerAddress, brokerInfo);
                TrackServer.this.publishTrackTable();
            }
        });
        this.registerHandler("track_sub", new MessageHandler(){

            public void handleMessage(Message msg, Session sess) throws IOException {
                TrackServer.this.subscribers.put(sess.id(), sess);
                String json = JSON.toJSONString((Object)TrackServer.this.trackTable);
                msg.setStatus("200");
                msg.setBody(json);
                sess.write((Object)msg);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        int serverPort = Helper.option((String[])args, (String)"-p", (int)16666);
        Dispatcher dispatcher = new Dispatcher();
        TrackServer track = new TrackServer(serverPort, dispatcher);
        track.start();
    }
}

