/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server.mq;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.protocol.ConsumerInfo;
import org.zstacks.zbus.protocol.MqInfo;
import org.zstacks.zbus.server.mq.store.MessageStore;
import org.zstacks.znet.Message;
import org.zstacks.znet.nio.Session;

public abstract class MessageQueue
implements Serializable {
    private static final long serialVersionUID = 5719362844495027862L;
    private static final Logger log = LoggerFactory.getLogger(MessageQueue.class);
    protected final String broker;
    protected final String name;
    protected String creator;
    protected long createdTime = System.currentTimeMillis();
    protected String accessToken = "";
    protected final int mode;
    protected transient ExecutorService executor;
    protected transient MessageStore messageStore = null;

    public MessageQueue(String broker, String name, ExecutorService executor, int mode) {
        this.broker = broker;
        this.name = name;
        this.executor = executor;
        this.mode = mode;
    }

    public abstract void produce(Message var1, Session var2) throws IOException;

    public abstract void consume(Message var1, Session var2) throws IOException;

    abstract void doDispatch() throws IOException;

    public abstract void cleanSession();

    void dispatch() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageQueue.this.doDispatch();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getName() {
        return this.name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public int getMode() {
        return this.mode;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public MqInfo getMqInfo() {
        MqInfo info = new MqInfo();
        info.setBroker(this.broker);
        info.setName(this.name);
        info.setCreator(this.creator);
        info.setCreatedTime(this.createdTime);
        info.setUnconsumedMsgCount(this.getMessageQueueSize());
        info.setConsumerInfoList(this.getConsumerInfoList());
        info.setMode(this.mode);
        return info;
    }

    public abstract int getMessageQueueSize();

    public abstract List<ConsumerInfo> getConsumerInfoList();

    public void prepareMessageStatus(Message msg) {
        String status = msg.getStatus();
        if (status == null) {
            status = msg.getReplyCode();
            if (status == null) {
                status = "200";
            }
            msg.setStatus(status);
        }
    }

    public String toString() {
        return "MQ [name=" + this.name + ", creator=" + this.creator + ", createdTime=" + this.createdTime + "]";
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }
}

