/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server.mq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.protocol.ConsumerInfo;
import org.zstacks.zbus.server.ServerHelper;
import org.zstacks.zbus.server.mq.MessageQueue;
import org.zstacks.zbus.server.mq.PullSession;
import org.zstacks.znet.Message;
import org.zstacks.znet.nio.Session;

public class PubsubQueue
extends MessageQueue {
    private static final long serialVersionUID = -593851217778104787L;
    private static final Logger log = LoggerFactory.getLogger(PubsubQueue.class);
    protected final BlockingQueue<Message> msgQ = new LinkedBlockingQueue<Message>();
    transient ConcurrentMap<String, PullSession> sessMap = new ConcurrentHashMap<String, PullSession>();

    public PubsubQueue(String broker, String name, ExecutorService executor, int mode) {
        super(broker, name, executor, mode);
    }

    @Override
    public void produce(Message msg, Session sess) throws IOException {
        String msgId = msg.getMsgId();
        if (msg.isAck()) {
            ServerHelper.reply200(msgId, sess);
        }
        this.msgQ.offer(msg);
        this.dispatch();
    }

    @Override
    public void consume(Message msg, Session sess) throws IOException {
        PullSession pull = (PullSession)this.sessMap.get(sess.id());
        if (pull != null) {
            pull.setPullMsg(msg);
        } else {
            pull = new PullSession(sess, msg);
            this.sessMap.putIfAbsent(sess.id(), pull);
        }
        this.dispatch();
    }

    @Override
    public void cleanSession() {
        Iterator iter = this.sessMap.entrySet().iterator();
        while (iter.hasNext()) {
            PullSession ps = (PullSession)iter.next().getValue();
            if (ps.session.isActive()) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doDispatch() throws IOException {
        Message msg = null;
        while ((msg = (Message)this.msgQ.poll()) != null) {
            String topic = msg.getTopic();
            Iterator iter = this.sessMap.entrySet().iterator();
            while (iter.hasNext()) {
                PullSession sess = (PullSession)iter.next().getValue();
                if (sess == null || !sess.getSession().isActive()) {
                    iter.remove();
                    continue;
                }
                if (!sess.isTopicMatched(topic)) continue;
                Message copy = Message.copyWithoutBody((Message)msg);
                this.prepareMessageStatus(copy);
                sess.getMsgQ().offer(copy);
            }
        }
        Iterator iter = this.sessMap.entrySet().iterator();
        while (iter.hasNext()) {
            PullSession sess = (PullSession)iter.next().getValue();
            if (sess == null || !sess.getSession().isActive()) {
                iter.remove();
                continue;
            }
            try {
                sess.pullMsgLock.lock();
                Message pullMsg = sess.getPullMsg();
                if (pullMsg == null || (msg = (Message)sess.getMsgQ().poll()) == null) continue;
                sess.setPullMsg(null);
                msg.setStatus("200");
                msg.setMsgIdRaw(pullMsg.getMsgId());
                msg.setMsgId(pullMsg.getMsgId());
                sess.getSession().write((Object)msg);
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                sess.pullMsgLock.unlock();
            }
        }
    }

    @Override
    public List<ConsumerInfo> getConsumerInfoList() {
        ArrayList<ConsumerInfo> res = new ArrayList<ConsumerInfo>();
        Iterator iter = this.sessMap.entrySet().iterator();
        while (iter.hasNext()) {
            PullSession value = (PullSession)iter.next().getValue();
            Session sess = value.getSession();
            ConsumerInfo info = new ConsumerInfo();
            info.setStatus(sess.getStatus().toString());
            info.setRemoteAddr(sess.getRemoteAddress());
            if (value.getTopics() != null) {
                info.setTopics(new ArrayList<String>(value.getTopics()));
            }
            res.add(info);
        }
        return res;
    }

    @Override
    public int getMessageQueueSize() {
        return this.msgQ.size();
    }
}

