/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server.mq;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.protocol.ConsumerInfo;
import org.zstacks.zbus.server.ServerHelper;
import org.zstacks.zbus.server.mq.MessageQueue;
import org.zstacks.zbus.server.mq.PullSession;
import org.zstacks.znet.Message;
import org.zstacks.znet.nio.Session;

public class ReplyQueue
extends MessageQueue {
    private static final long serialVersionUID = -2343230968503191635L;
    private static final Logger log = LoggerFactory.getLogger(ReplyQueue.class);
    protected final ConcurrentMap<String, Message> msgQ = new ConcurrentHashMap<String, Message>();
    transient PullSession pullSession = null;

    public ReplyQueue(String broker, String name, ExecutorService executor, int mode) {
        super(broker, name, executor, mode);
    }

    @Override
    public void produce(Message msg, Session sess) throws IOException {
        String msgId = msg.getMsgId();
        if (msg.isAck()) {
            ServerHelper.reply200(msgId, sess);
        }
        this.msgQ.put(msgId, msg);
        this.dispatch();
    }

    @Override
    public void consume(Message msg, Session sess) throws IOException {
        if (this.pullSession == null) {
            this.pullSession = new PullSession(sess, msg);
        }
        this.pullSession.setSession(sess);
        this.pullSession.setPullMsg(msg);
        this.dispatch();
    }

    @Override
    public void cleanSession() {
    }

    @Override
    void doDispatch() throws IOException {
        if (this.pullSession == null) {
            return;
        }
        if (this.pullSession.getSession() == null) {
            return;
        }
        if (this.pullSession.getPullMsg() == null) {
            return;
        }
        String msgId = this.pullSession.getPullMsg().getMsgId();
        if (this.msgQ.containsKey(msgId)) {
            Message msg = (Message)this.msgQ.get(msgId);
            if (!msgId.equals(msg.getMsgId())) {
                return;
            }
            this.msgQ.remove(msgId);
            try {
                this.prepareMessageStatus(msg);
                this.pullSession.getSession().write((Object)msg);
                if (this.pullSession.window.get() > 0) {
                    this.pullSession.window.decrementAndGet();
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            if (this.pullSession.window.get() != -1 && this.pullSession.window.get() <= 0) {
                this.pullSession.setSession(null);
            }
        }
    }

    @Override
    public List<ConsumerInfo> getConsumerInfoList() {
        ArrayList<ConsumerInfo> res = new ArrayList<ConsumerInfo>();
        if (this.pullSession != null && this.pullSession.getSession() != null) {
            PullSession value = this.pullSession;
            Session sess = value.getSession();
            ConsumerInfo info = new ConsumerInfo();
            info.setStatus(sess.getStatus().toString());
            info.setRemoteAddr(sess.getRemoteAddress());
            res.add(info);
        }
        return res;
    }

    @Override
    public int getMessageQueueSize() {
        return this.msgQ.size();
    }
}

