/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.zbus.server.mq.store;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.zbus.server.mq.store.MessageStore;
import org.zstacks.zbus.server.mq.store.MessageStoreDummy;
import org.zstacks.zbus.server.mq.store.MessageStoreSql;

public class MessageStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(MessageStoreFactory.class);
    public static final String SQL = "sql";
    public static final String DUMMY = "dummy";

    public static MessageStore getMessageStore(String borker, String type) {
        try {
            if (SQL.equals(type)) {
                log.info("Using SQL store");
                MessageStoreSql store = new MessageStoreSql(borker);
                store.start();
                return store;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.warn("default to dummy store");
        }
        return new MessageStoreDummy();
    }
}

