/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.znet.Meta;

public class Message
implements Serializable {
    private static final long serialVersionUID = 4379223525215626137L;
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    public static final String HEARTBEAT = "heartbeat";
    public static final String HEADER_REMOTE_ADDR = "remote-addr";
    public static final String HEADER_CONTENT_ENCODING = "content-encoding";
    public static final String HEADER_CONTENT_LENGTH = "content-length";
    public static final String HEADER_CONTENT_TYPE = "content-type";
    public static final String HEADER_CMD = "cmd";
    public static final String HEADER_SUBCMD = "sub_cmd";
    public static final String HEADER_MQ = "mq";
    public static final String HEADER_MQ_REPLY = "mq_reply";
    public static final String HEADER_MSGID = "msgid";
    public static final String HEADER_MSGID_RAW = "msgid_raw";
    public static final String HEADER_TOKEN = "token";
    public static final String HEADER_BROKER = "broker";
    public static final String HEADER_TOPIC = "topic";
    public static final String HEADER_ACK = "ack";
    public static final String HEADER_WINDOW = "window";
    public static final String HEADER_REPLY_CODE = "reply_code";
    protected Meta meta = new Meta();
    protected Map<String, String> head = new ConcurrentHashMap<String, String>();
    protected byte[] body;

    public Message() {
        this.setBody((byte[])null);
    }

    public static Message copyWithoutBody(Message msg) {
        Message res = new Message();
        res.meta = new Meta(msg.meta);
        res.head = new HashMap<String, String>(msg.head);
        res.body = msg.body;
        return res;
    }

    public String getMetaString() {
        return this.meta.toString();
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) {
        this.meta = new Meta(meta);
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public Map<String, String> getHead() {
        return this.head;
    }

    public void setHead(Map<String, String> head) {
        this.head = head;
    }

    public String getHead(String key) {
        return this.head.get(key);
    }

    public void setHead(String key, String value) {
        if (value == null) {
            return;
        }
        this.head.put(key, value);
    }

    public String removeHead(String key) {
        return this.head.remove(key);
    }

    public String getParam(String key) {
        return this.meta.getParam(key);
    }

    public String getHeadOrParam(String key) {
        String value = this.getHead(key);
        if (value == null) {
            value = this.getParam(key);
        }
        return value;
    }

    public String getHeadOrParam(String key, String defaultValue) {
        String value = this.getHeadOrParam(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public byte[] getBody() {
        byte[] b = this.body;
        String bodyOfHead = this.getHead("body");
        if (b == null && bodyOfHead != null) {
            b = bodyOfHead.getBytes();
        }
        return b;
    }

    public void setBody(byte[] body) {
        int len = 0;
        if (body != null) {
            len = body.length;
        }
        this.setHead(HEADER_CONTENT_LENGTH, "" + len);
        this.body = body;
    }

    public void setBody(String body) {
        this.setBody(body.getBytes());
    }

    public Message setBody(String format, Object ... args) {
        this.setBody(String.format(format, args));
        return this;
    }

    public void setJsonBody(String body) {
        this.setJsonBody(body.getBytes());
    }

    public void setJsonBody(byte[] body) {
        this.setHead(HEADER_CONTENT_TYPE, "application/json");
        this.setBody(body);
    }

    public String getBodyString() {
        if (this.getBody() == null) {
            return null;
        }
        return new String(this.getBody());
    }

    public String getBodyString(String encoding) {
        if (this.getBody() == null) {
            return null;
        }
        try {
            return new String(this.getBody(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.getBody());
        }
    }

    public void decodeHeaders(byte[] data, int offset, int size) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data, offset, size)));
            String meta = in.readLine();
            if (meta == null) {
                return;
            }
            this.meta = new Meta(meta);
            String line = in.readLine();
            while (line != null && line.trim().length() > 0) {
                int p = line.indexOf(58);
                if (p >= 0) {
                    this.head.put(line.substring(0, p).trim().toLowerCase(), line.substring(p + 1).trim());
                }
                line = in.readLine();
            }
            if (this.meta.params != null) {
                for (Map.Entry<String, String> kv : this.meta.params.entrySet()) {
                    String key = kv.getKey().toLowerCase();
                    if (this.head.containsKey(key)) continue;
                    this.head.put(key, kv.getValue());
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public int estimatedSize() {
        int size = 0;
        size += this.meta.toString().length();
        for (Map.Entry<String, String> e : this.head.entrySet()) {
            size += e.getKey().length() + e.getKey().length();
        }
        if (this.body != null) {
            size += this.body.length;
        }
        return size;
    }

    public String getCommand() {
        return this.getHeadOrParam(HEADER_CMD);
    }

    public Message setCommand(String value) {
        this.setHead(HEADER_CMD, value);
        return this;
    }

    public String getSubCommand() {
        return this.getHeadOrParam(HEADER_SUBCMD);
    }

    public Message setSubCommand(String value) {
        this.setHead(HEADER_SUBCMD, value);
        return this;
    }

    public String getBroker() {
        return this.getHeadOrParam(HEADER_BROKER);
    }

    public void setBroker(String value) {
        this.setHead(HEADER_BROKER, value);
    }

    public String getMqReply() {
        return this.getHeadOrParam(HEADER_MQ_REPLY);
    }

    public Message setMqReply(String value) {
        this.setHead(HEADER_MQ_REPLY, value);
        return this;
    }

    public String getEncoding() {
        return this.getHeadOrParam(HEADER_CONTENT_ENCODING);
    }

    public Message setEncoding(String encoding) {
        this.setHead(HEADER_CONTENT_ENCODING, encoding);
        return this;
    }

    public String getMsgId() {
        return this.getHeadOrParam(HEADER_MSGID);
    }

    public Message setMsgId(String msgId) {
        if (msgId == null) {
            return this;
        }
        this.setHead(HEADER_MSGID, msgId);
        return this;
    }

    public String getMsgIdRaw() {
        return this.getHeadOrParam(HEADER_MSGID_RAW);
    }

    public Message setMsgIdRaw(String value) {
        if (value == null) {
            return this;
        }
        this.setHead(HEADER_MSGID_RAW, value);
        return this;
    }

    public boolean isAck() {
        String ack = this.getHeadOrParam(HEADER_ACK);
        if (ack == null) {
            return true;
        }
        return (ack = ack.trim().toLowerCase()).equals("1") || ack.equals("true");
    }

    public void setAck(boolean ack) {
        String value = ack ? "1" : "0";
        this.setHead(HEADER_ACK, value);
    }

    public String getMq() {
        String value = this.getHeadOrParam(HEADER_MQ);
        if (value == null) {
            value = this.getPath();
        }
        return value;
    }

    public String getUri() {
        return this.meta.uri;
    }

    public String getPath() {
        return this.meta.path;
    }

    public Message setMq(String mq) {
        this.setHead(HEADER_MQ, mq);
        return this;
    }

    public String getToken() {
        return this.getHeadOrParam(HEADER_TOKEN);
    }

    public Message setToken(String token) {
        this.setHead(HEADER_TOKEN, token);
        return this;
    }

    public String getTopic() {
        return this.getHeadOrParam(HEADER_TOPIC);
    }

    public Message setTopic(String topic) {
        this.setHead(HEADER_TOPIC, topic);
        return this;
    }

    public String getWindow() {
        return this.getHeadOrParam(HEADER_WINDOW);
    }

    public Message setWindow(int window) {
        this.setHead(HEADER_WINDOW, "" + window);
        return this;
    }

    public String getReplyCode() {
        return this.getHeadOrParam(HEADER_REPLY_CODE);
    }

    public Message setReplyCode(String value) {
        this.setHead(HEADER_REPLY_CODE, value);
        return this;
    }

    public String getStatus() {
        return this.meta.status;
    }

    public Message setStatus(String status) {
        this.meta.status = status;
        return this;
    }

    public boolean isStatus200() {
        return "200".equals(this.getStatus());
    }

    public boolean isStatus404() {
        return "404".equals(this.getStatus());
    }

    public boolean isStatus500() {
        return "500".equals(this.getStatus());
    }

    protected String getBodyPrintString() {
        if (this.body == null) {
            return null;
        }
        if (this.body.length > 1024) {
            return new String(this.body, 0, 1024) + "...";
        }
        return this.getBodyString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.meta + "\r\n");
        ArrayList<String> keys = new ArrayList<String>(this.head.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String val = this.head.get(key);
            sb.append(key + ": " + val + "\r\n");
        }
        sb.append("\r\n");
        String bodyString = this.getBodyPrintString();
        if (bodyString != null) {
            sb.append(bodyString);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Message msg = new Message();
        msg.setStatus("200");
        msg.setStatus(null);
        System.out.println(msg);
    }
}

