/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet;

import java.util.Map;
import org.zstacks.znet.Message;
import org.zstacks.znet.nio.IoAdaptor;
import org.zstacks.znet.nio.IoBuffer;

public class MessageAdaptor
extends IoAdaptor {
    @Override
    public IoBuffer encode(Object obj) {
        if (!(obj instanceof Message)) {
            throw new RuntimeException("Message unknown");
        }
        Message msg = (Message)obj;
        IoBuffer buf = IoBuffer.allocate(1024);
        buf.put(msg.getMetaString() + "\r\n");
        Map<String, String> headers = msg.getHead();
        int contentLength = 0;
        if (msg.getBody() != null) {
            contentLength = msg.getBody().length;
        }
        String lenKey = "content-length";
        for (Map.Entry<String, String> e : headers.entrySet()) {
            buf.put(e.getKey() + ": " + e.getValue() + "\r\n");
        }
        if (!headers.containsKey(lenKey)) {
            buf.put(lenKey + ": " + contentLength + "\r\n");
        }
        buf.put("\r\n");
        if (msg.getBody() != null) {
            buf.put(msg.getBody());
        }
        buf.flip();
        return buf;
    }

    @Override
    public Object decode(IoBuffer buf) {
        int headerIdx = MessageAdaptor.findHeaderEnd(buf);
        if (headerIdx == -1) {
            return null;
        }
        int headerLen = headerIdx + 1 - buf.position();
        buf.mark();
        Message msg = new Message();
        msg.decodeHeaders(buf.array(), buf.position(), headerLen);
        buf.position(buf.position() + headerLen);
        String contentLength = msg.getHeadOrParam("content-length");
        if (contentLength == null) {
            return msg;
        }
        int bodyLen = Integer.valueOf(contentLength);
        if (buf.remaining() < bodyLen) {
            buf.reset();
            return null;
        }
        byte[] body = new byte[bodyLen];
        buf.get(body);
        msg.setBody(body);
        return msg;
    }

    private static int findHeaderEnd(IoBuffer buf) {
        byte[] data = buf.array();
        int i = buf.position();
        int limit = buf.limit();
        while (i + 3 < limit) {
            if (data[i] != 13) {
                ++i;
                continue;
            }
            if (data[i + 1] != 10) {
                i += 2;
                continue;
            }
            if (data[i + 2] != 13) {
                i += 2;
                continue;
            }
            if (data[i + 3] != 10) {
                i += 3;
                continue;
            }
            return i + 3;
        }
        return -1;
    }
}

