/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

class Meta
implements Serializable {
    private static final long serialVersionUID = -8557063231118504061L;
    String status;
    String method = "GET";
    String uri = "/";
    String path;
    Map<String, String> params;
    static Set<String> httpMethod = new HashSet<String>();
    static Map<String, String> httpStatus = new HashMap<String, String>();

    public String toString() {
        if (this.status != null) {
            String desc = httpStatus.get(this.status);
            if (desc == null) {
                desc = "Unknown Status";
            }
            return String.format("HTTP/1.1 %s %s", this.status, desc);
        }
        String method = this.method;
        String uri = this.uri;
        if (this.method == null) {
            method = "";
        }
        if (this.uri == null) {
            uri = "";
        }
        return String.format("%s %s HTTP/1.1", method, uri);
    }

    public Meta() {
    }

    public Meta(Meta m) {
        this.uri = m.uri;
        this.path = m.path;
        this.method = m.method;
        this.status = m.status;
        if (m.params != null) {
            this.params = new HashMap<String, String>(m.params);
        }
    }

    public Meta(String meta) {
        if ("".equals(meta)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(meta);
        String firstWord = st.nextToken();
        if (firstWord.toUpperCase().startsWith("HTTP")) {
            this.status = st.nextToken();
            return;
        }
        this.method = firstWord;
        this.uri = st.nextToken();
        this.decodeURI(this.uri);
    }

    private void decodeURI(String commandString) {
        int idx = commandString.indexOf(63);
        this.path = idx < 0 ? this.decodeUrl(commandString) : commandString.substring(0, idx);
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        if (idx < 0) {
            return;
        }
        this.params = new HashMap<String, String>();
        String paramString = commandString.substring(idx + 1);
        StringTokenizer st = new StringTokenizer(paramString, "&");
        while (st.hasMoreTokens()) {
            String e = st.nextToken();
            int sep = e.indexOf(61);
            if (sep >= 0) {
                this.params.put(this.decodeUrl(e.substring(0, sep)).trim(), this.decodeUrl(e.substring(sep + 1)));
                continue;
            }
            this.params.put(this.decodeUrl(e).trim(), "");
        }
    }

    private String decodeUrl(String str) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(str, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public String getParam(String key) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    public String getParam(String key, String defaultValue) {
        String value = this.getParam(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    static {
        httpMethod.add("GET");
        httpMethod.add("POST");
        httpMethod.add("PUT");
        httpMethod.add("DELETE");
        httpMethod.add("HEAD");
        httpMethod.add("OPTIONS");
        httpStatus.put("101", "Switching Protocols");
        httpStatus.put("200", "OK");
        httpStatus.put("201", "Created");
        httpStatus.put("202", "Accepted");
        httpStatus.put("204", "No Content");
        httpStatus.put("206", "Partial Content");
        httpStatus.put("301", "Moved Permanently");
        httpStatus.put("304", "Not Modified");
        httpStatus.put("400", "Bad Request");
        httpStatus.put("401", "Unauthorized");
        httpStatus.put("403", "Forbidden");
        httpStatus.put("404", "Not Found");
        httpStatus.put("405", "Method Not Allowed");
        httpStatus.put("416", "Requested Range Not Satisfiable");
        httpStatus.put("500", "Internal Server Error");
    }
}

