/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.znet.Helper;
import org.zstacks.znet.Message;
import org.zstacks.znet.MessageAdaptor;
import org.zstacks.znet.MessageHandler;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.nio.Session;

public class RemotingServer
extends MessageAdaptor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RemotingServer.class);
    protected Map<String, MessageHandler> handlerMap = new ConcurrentHashMap<String, MessageHandler>();
    protected MessageHandler globalHandler;
    protected Dispatcher dispatcher;
    protected String host = "0.0.0.0";
    protected int port;
    protected final String serverAddr;
    protected String serverName = "RemotingServer";
    protected ServerSocketChannel serverChannel;

    public RemotingServer(int port, Dispatcher dispatcher) {
        this("0.0.0.0", port, dispatcher);
    }

    public RemotingServer(String host, int port, Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.host = host;
        this.port = port;
        this.dispatcher.serverIoAdaptor(this);
        this.serverAddr = "0.0.0.0".equals(this.host) ? String.format("%s:%d", Helper.getLocalIp(), this.port) : String.format("%s:%d", this.host, this.port);
        this.registerHandler("heartbeat", new MessageHandler(){

            @Override
            public void handleMessage(Message msg, Session sess) throws IOException {
            }
        });
    }

    public void registerHandler(String command, MessageHandler handler) {
        this.handlerMap.put(command, handler);
    }

    public void registerGlobalHandler(MessageHandler beforeHandler) {
        this.globalHandler = beforeHandler;
    }

    public String findHandlerKey(Message msg) {
        return msg.getCommand();
    }

    @Override
    public void onMessage(Object obj, Session sess) throws IOException {
        String cmd;
        Message msg = (Message)obj;
        if (this.globalHandler != null) {
            this.globalHandler.handleMessage(msg, sess);
        }
        if ((cmd = this.findHandlerKey(msg)) == null) {
            Message res = new Message();
            res.setMsgId(msg.getMsgId());
            res.setStatus("400");
            res.setBody("Bad format: missing command");
            sess.write(res);
            return;
        }
        MessageHandler handler = this.handlerMap.get(cmd);
        if (handler != null) {
            handler.handleMessage(msg, sess);
            return;
        }
        Message res = new Message();
        res.setMsgId(msg.getMsgId());
        res.setStatus("400");
        String text = String.format("Bad format: command(%s) not support", cmd);
        res.setBody(text);
        sess.write(res);
    }

    public void start() throws IOException {
        if (this.serverChannel != null) {
            log.info("server already started");
            return;
        }
        if (!this.dispatcher.isStarted()) {
            this.dispatcher.start();
        }
        this.serverChannel = this.dispatcher.registerServerChannel(this.host, this.port);
        log.info("{} serving@{}:{}", new Object[]{this.serverName, this.host, this.port});
    }

    @Override
    public void close() throws IOException {
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
    }
}

