/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet.nio;

import java.io.IOException;
import org.zstacks.znet.nio.IoBuffer;
import org.zstacks.znet.nio.Session;

public abstract class IoAdaptor {
    public abstract IoBuffer encode(Object var1);

    public abstract Object decode(IoBuffer var1);

    public void onSessionAccepted(Session sess) throws IOException {
        sess.dispatcher().registerSession(1, sess);
    }

    public void onSessionRegistered(Session sess) throws IOException {
    }

    public void onSessionConnected(Session sess) throws IOException {
        sess.interestOps(5);
    }

    public void onSessionDestroyed(Session sess) throws IOException {
    }

    public void onMessage(Object msg, Session sess) throws IOException {
    }

    public void onException(Throwable e, Session sess) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e.getMessage(), e);
    }
}

