/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zstacks.znet.Helper;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.nio.IoAdaptor;
import org.zstacks.znet.nio.IoBuffer;
import org.zstacks.znet.nio.SelectorThread;

public class Session
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private SessionStatus status = SessionStatus.NEW;
    private long lastOperationTime = System.currentTimeMillis();
    private final String id;
    private int bufferSize = 8192;
    private IoBuffer readBuffer = null;
    private Queue<ByteBuffer> writeBufferQ = new LinkedBlockingQueue<ByteBuffer>();
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private final Dispatcher dispatcher;
    private final SocketChannel channel;
    private SelectionKey registeredKey = null;
    private ConcurrentMap<String, Object> attributes = null;
    private Object attachment;
    private final IoAdaptor ioAdaptor;

    public Session(Dispatcher dispatcher, SocketChannel channel, IoAdaptor ioAdaptor) {
        this(dispatcher, channel, null, ioAdaptor);
    }

    public Session(Dispatcher dispatcher, SocketChannel channel, Object attachment, IoAdaptor ioAdaptor) {
        this.dispatcher = dispatcher;
        this.id = UUID.randomUUID().toString();
        this.channel = channel;
        this.attachment = attachment;
        this.ioAdaptor = ioAdaptor;
    }

    public String id() {
        return "" + this.id;
    }

    @Override
    public void close() throws IOException {
        if (this.status == SessionStatus.CLOSED) {
            return;
        }
        this.status = SessionStatus.CLOSED;
        if (this.registeredKey != null) {
            this.registeredKey.cancel();
            this.registeredKey = null;
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public void asyncClose() throws IOException {
        if (this.registeredKey == null) {
            return;
        }
        SelectorThread selector = this.dispatcher.getSelector(this.registeredKey);
        if (selector == null) {
            throw new IOException("failed to find dispatcher for session: " + this);
        }
        selector.unregisterSession(this);
    }

    public void write(Object msg) throws IOException {
        this.write(this.ioAdaptor.encode(msg));
    }

    public void write(IoBuffer buf) throws IOException {
        if (this.registeredKey == null) {
            throw new IOException("Session not registered yet:" + this);
        }
        if (!this.writeBufferQ.offer(buf.buf())) {
            String msg = "Session write buffer queue is full, message count=" + this.writeBufferQ.size();
            log.warn(msg);
            throw new IOException(msg);
        }
        this.registeredKey.interestOps(this.registeredKey.interestOps() | 4);
        this.registeredKey.selector().wakeup();
    }

    public void doRead() throws IOException {
        if (this.readBuffer == null) {
            this.readBuffer = IoBuffer.allocate(this.bufferSize);
        }
        ByteBuffer data = ByteBuffer.allocate(4096);
        int n = 0;
        while ((n = this.channel.read(data)) > 0) {
            data.flip();
            this.readBuffer.put(data.array(), data.position(), data.remaining());
            data.clear();
        }
        if (n < 0) {
            this.ioAdaptor.onSessionDestroyed(this);
            this.asyncClose();
            return;
        }
        IoBuffer tempBuf = this.readBuffer.duplicate().flip();
        Object msg = null;
        while (true) {
            tempBuf.mark();
            msg = tempBuf.remaining() > 0 ? this.ioAdaptor.decode(tempBuf) : null;
            if (msg == null) break;
            final Object theMsg = msg;
            this.dispatcher.asyncRun(new Runnable(){

                @Override
                public void run() {
                    try {
                        Session.this.ioAdaptor.onMessage(theMsg, Session.this);
                    }
                    catch (Throwable e) {
                        try {
                            Session.this.ioAdaptor.onException(e, Session.this);
                        }
                        catch (IOException e1) {
                            try {
                                Session.this.close();
                            }
                            catch (Throwable e2) {
                                log.error(e2.getMessage(), e2);
                            }
                        }
                    }
                }
            });
        }
        tempBuf.reset();
        this.readBuffer = this.resetIoBuffer(tempBuf);
    }

    protected IoBuffer resetIoBuffer(IoBuffer buffer) {
        IoBuffer newBuffer = null;
        if (buffer != null && buffer.remaining() > 0) {
            int len = buffer.remaining();
            byte[] bb = new byte[len];
            buffer.get(bb);
            newBuffer = IoBuffer.wrap(bb);
            newBuffer.position(len);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWrite() throws IOException {
        int n = 0;
        Queue<ByteBuffer> queue = this.writeBufferQ;
        synchronized (queue) {
            while (true) {
                ByteBuffer buf;
                if ((buf = this.writeBufferQ.peek()) == null) {
                    this.registeredKey.interestOps(1);
                    break;
                }
                int wbytes = this.channel.write(buf);
                if (wbytes == 0 && buf.remaining() > 0) break;
                n += wbytes;
                if (buf.remaining() != 0) break;
                this.writeBufferQ.remove();
            }
        }
        return n;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Session) {
            Session other = (Session)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public long getLastOperationTime() {
        return this.lastOperationTime;
    }

    public void updateLastOperationTime() {
        this.lastOperationTime = System.currentTimeMillis();
    }

    public String getRemoteAddress() {
        if (this.status != SessionStatus.CLOSED) {
            InetAddress addr = this.channel.socket().getInetAddress();
            return String.format("%s:%d", addr.getHostAddress(), this.channel.socket().getPort());
        }
        return null;
    }

    public String getLocalAddress() {
        if (this.status != SessionStatus.CLOSED) {
            return Helper.localAddress(this.channel);
        }
        return null;
    }

    public int interestOps() throws IOException {
        if (this.registeredKey == null) {
            throw new IOException("Session not registered yet:" + this);
        }
        return this.registeredKey.interestOps();
    }

    public void register(int interestOps) throws IOException {
        this.dispatcher.registerSession(interestOps, this);
    }

    public void interestOps(int ops) {
        if (this.registeredKey == null) {
            throw new IllegalStateException("registered session required");
        }
        this.registeredKey.interestOps(ops);
    }

    public void interestOpsAndWakeup(int ops) {
        this.interestOps(ops);
        this.registeredKey.selector().wakeup();
    }

    public SelectionKey getRegisteredKey() {
        return this.registeredKey;
    }

    public void setRegisteredKey(SelectionKey key) {
        this.registeredKey = key;
    }

    public SessionStatus getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status == SessionStatus.CONNECTED;
    }

    public boolean isNew() {
        return this.status == SessionStatus.NEW;
    }

    public void setStatus(SessionStatus status) {
        this.status = status;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public void finishConnect() {
        this.connectLatch.countDown();
    }

    public boolean waitToConnect(long millis) {
        try {
            return this.connectLatch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public <T> T attr(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (T)this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void attr(String key, T value) {
        if (this.attributes == null) {
            Session session = this;
            synchronized (session) {
                if (this.attributes == null) {
                    this.attributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        this.attributes.put(key, value);
    }

    public String toString() {
        return "Session [remote=" + this.getRemoteAddress() + ", status=" + (Object)((Object)this.status) + ", id=" + this.id + "]";
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public IoAdaptor getIoAdaptor() {
        return this.ioAdaptor;
    }

    public static enum SessionStatus {
        NEW,
        CONNECTED,
        ON_ERROR,
        CLOSED;

    }
}

