/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet.pool;

import java.io.IOException;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.zstacks.znet.RemotingClient;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.pool.RemotingClientPoolConfig;

class RemotingClientFactory
extends BasePooledObjectFactory<RemotingClient> {
    Dispatcher dispatcher;
    private final String broker;

    public RemotingClientFactory(RemotingClientPoolConfig config) throws IOException {
        this.broker = config.getBrokerAddress();
    }

    public RemotingClient create() throws Exception {
        return new RemotingClient(this.broker, this.dispatcher);
    }

    public PooledObject<RemotingClient> wrap(RemotingClient obj) {
        return new DefaultPooledObject((Object)obj);
    }

    public void destroyObject(PooledObject<RemotingClient> p) throws Exception {
        RemotingClient client = (RemotingClient)p.getObject();
        client.close();
    }

    public boolean validateObject(PooledObject<RemotingClient> p) {
        return ((RemotingClient)p.getObject()).hasConnected();
    }
}

