/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet.pool;

import java.io.IOException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.zstacks.znet.RemotingClient;
import org.zstacks.znet.nio.Dispatcher;
import org.zstacks.znet.pool.RemotingClientFactory;
import org.zstacks.znet.pool.RemotingClientPoolConfig;

public class RemotingClientPool
extends GenericObjectPool<RemotingClient> {
    private Dispatcher dispatcher = null;
    private boolean ownDispatcher = false;

    public RemotingClientPool(RemotingClientPoolConfig config) throws IOException {
        super((PooledObjectFactory)new RemotingClientFactory(config), (GenericObjectPoolConfig)config);
        RemotingClientFactory factory = (RemotingClientFactory)this.getFactory();
        this.dispatcher = config.getDispatcher();
        if (this.dispatcher == null) {
            this.dispatcher = new Dispatcher().selectorCount(config.getSelectorCount()).executorCount(config.getExecutorCount());
            this.ownDispatcher = true;
        }
        this.dispatcher.start();
        factory.dispatcher = this.dispatcher;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void close() {
        super.close();
        try {
            if (this.ownDispatcher && this.dispatcher != null) {
                this.dispatcher.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

