/*
 * Decompiled with CFR 0.152.
 */
package org.zstacks.znet.ticket;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.zstacks.znet.Message;
import org.zstacks.znet.ticket.ResultCallback;
import org.zstacks.znet.ticket.Ticket;

public class TicketManager {
    private ConcurrentMap<String, Ticket> tickets = new ConcurrentHashMap<String, Ticket>();

    public Ticket getTicket(String id) {
        if (id == null) {
            return null;
        }
        return (Ticket)this.tickets.get(id);
    }

    public Ticket createTicket(Message req, long timeout) {
        return this.createTicket(req, timeout, null);
    }

    public Ticket createTicket(Message req, long timeout, ResultCallback callback) {
        Ticket ticket = new Ticket(req, timeout);
        ticket.setCallback(callback);
        if (this.tickets.putIfAbsent(ticket.getId(), ticket) != null) {
            throw new IllegalArgumentException("duplicate ticket number.");
        }
        return ticket;
    }

    public void removeTicket(String id) {
        this.tickets.remove(id);
    }
}

